/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.weighted;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.graph.weighted.WIntEdge;

public class WVertex
implements Comparable<WVertex> {
    private int id;
    private Map<WVertex, WIntEdge> outgoing;
    private Map<WVertex, WIntEdge> incoming;

    public WVertex() {
        this.id = this.hashCode();
        this.outgoing = new HashMap<WVertex, WIntEdge>();
        this.incoming = new HashMap<WVertex, WIntEdge>();
    }

    public Collection<WIntEdge> getIncoming() {
        return this.incoming.values();
    }

    public WIntEdge getIncoming(WVertex source) {
        return this.incoming.get(source);
    }

    public Collection<WIntEdge> getOutgoing() {
        return this.outgoing.values();
    }

    public WIntEdge getOutgoing(WVertex target) {
        return this.outgoing.get(target);
    }

    public void addIncoming(WIntEdge e) {
        this.incoming.put(e.getSource(), e);
    }

    public void addOutgoing(WIntEdge e) {
        this.outgoing.put(e.getTarget(), e);
    }

    public WVertex(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public int compareTo(WVertex other) {
        return Integer.compare(this.id, other.id);
    }
}

