/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.scheduler;

public final class CollectedScheduleData {
    final double[] startTime;

    final double[] duration;

    final double[] critical;

    private final int samplelength;

    public CollectedScheduleData(int sampleLength) {
        this.samplelength = sampleLength;
        startTime = new double[sampleLength];
        duration = new double[sampleLength];
        critical = new double[sampleLength];
    }

    public int getSampleLength() {
        return samplelength;
    }

    public double[] getStartTime() {
        return startTime;
    }

    public double[] getDuration() {
        return duration;
    }

    public double[] getCritical() {
        return critical;
    }
}
