/**
 */
package product.util;

import common.HasName;
import common.TypeDefinition;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import product.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see product.ProductPackage
 * @generated
 */
public class ProductAdapterFactory extends AdapterFactoryImpl
{
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static ProductPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ProductAdapterFactory()
    {
        if (modelPackage == null)
        {
            modelPackage = ProductPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object object)
    {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProductSwitch<Adapter> modelSwitch =
        new ProductSwitch<Adapter>()
        {
            @Override
            public Adapter caseProductDefinition(ProductDefinition object)
            {
                return createProductDefinitionAdapter();
            }
            @Override
            public Adapter casePropertyDefinition(PropertyDefinition object)
            {
                return createPropertyDefinitionAdapter();
            }
            @Override
            public Adapter caseProperty(Property object)
            {
                return createPropertyAdapter();
            }
            @Override
            public Adapter caseProductValue(ProductValue object)
            {
                return createProductValueAdapter();
            }
            @Override
            public Adapter caseStringValue(StringValue object)
            {
                return createStringValueAdapter();
            }
            @Override
            public Adapter caseBooleanValue(BooleanValue object)
            {
                return createBooleanValueAdapter();
            }
            @Override
            public Adapter caseIntegerValue(IntegerValue object)
            {
                return createIntegerValueAdapter();
            }
            @Override
            public Adapter caseIProductDefinition(IProductDefinition object)
            {
                return createIProductDefinitionAdapter();
            }
            @Override
            public Adapter caseHasName(HasName object)
            {
                return createHasNameAdapter();
            }
            @Override
            public Adapter caseTypeDefinition(TypeDefinition object)
            {
                return createTypeDefinitionAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object)
            {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(Notifier target)
    {
        return modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link product.ProductDefinition <em>Definition</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.ProductDefinition
     * @generated
     */
    public Adapter createProductDefinitionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.PropertyDefinition <em>Property Definition</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.PropertyDefinition
     * @generated
     */
    public Adapter createPropertyDefinitionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.Property <em>Property</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.Property
     * @generated
     */
    public Adapter createPropertyAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.ProductValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.ProductValue
     * @generated
     */
    public Adapter createProductValueAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.StringValue <em>String Value</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.StringValue
     * @generated
     */
    public Adapter createStringValueAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.BooleanValue <em>Boolean Value</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.BooleanValue
     * @generated
     */
    public Adapter createBooleanValueAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.IntegerValue <em>Integer Value</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.IntegerValue
     * @generated
     */
    public Adapter createIntegerValueAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link product.IProductDefinition <em>IProduct Definition</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see product.IProductDefinition
     * @generated
     */
    public Adapter createIProductDefinitionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.HasName <em>Has Name</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.HasName
     * @generated
     */
    public Adapter createHasNameAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link common.TypeDefinition <em>Type Definition</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see common.TypeDefinition
     * @generated
     */
    public Adapter createTypeDefinitionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter()
    {
        return null;
    }

} //ProductAdapterFactory
