/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractTestWithProject
extends AbstractTest {
    protected IProject project;

    @BeforeEach
    public void setUpProject(TestInfo testInfo) throws Exception {
        String testClass = testInfo.getTestClass().map(Class::getSimpleName).orElse("UnknownTestClass");
        String testMethod = testInfo.getTestMethod().map(Method::getName).orElse("UnknownTestMethod");
        String projectName = testClass + "_" + testMethod + "_" + System.currentTimeMillis();
        this.project = TestUtils.createProject(projectName);
    }

    @AfterEach
    public void tearDownProject() throws Exception {
        if (this.project != null && this.project.exists()) {
            AbstractTestWithProject.deleteProjectWithRetries(this.project, 10, 500L);
        }
    }

    private static void deleteProjectWithRetries(IProject project, int maxAttempts, long delayMillis) throws CoreException {
        int attempt = 1;
        while (attempt <= maxAttempts) {
            try {
                if (!project.exists()) break;
                project.close(null);
                project.delete(5, null);
                break;
            }
            catch (CoreException ex) {
                if (attempt == maxAttempts) {
                    throw ex;
                }
                try {
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    ex.printStackTrace();
                    break;
                }
                ++attempt;
            }
        }
    }
}

