/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.messages;

import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> forLeft(@NonNull L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> forRight(@NonNull R right) {
        return new Either<Object, R>(null, right);
    }

    protected Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public Object get() {
        if (this.left != null) {
            return this.left;
        }
        if (this.right != null) {
            return this.right;
        }
        return null;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <T> T map(@NonNull Function<? super L, ? extends T> mapLeft, @NonNull Function<? super R, ? extends T> mapRight) {
        if (this.isLeft()) {
            return mapLeft.apply(this.getLeft());
        }
        if (this.isRight()) {
            return mapRight.apply(this.getRight());
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Either) {
            Either other = (Either)obj;
            return this.left == other.left && this.right == other.right || this.left != null && other.left != null && this.left.equals(other.left) || this.right != null && other.right != null && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        if (this.left != null) {
            return this.left.hashCode();
        }
        if (this.right != null) {
            return this.right.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Either [").append(System.lineSeparator());
        builder.append("  left = ").append(this.left).append(System.lineSeparator());
        builder.append("  right = ").append(this.right).append(System.lineSeparator());
        return builder.append("]").toString();
    }
}

