/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.persistence;

import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class PersistenceEntityDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-persistence";
    }

    private boolean isStatic(int flag) {
        Integer isPublicStatic = flag - 1;
        Integer isPrivateStatic = flag - 2;
        Integer isFinalStatic = flag - 16;
        Integer isProtectedStatic = flag - 4;
        Integer isStatic = flag;
        return isPublicStatic.equals(8) || isPrivateStatic.equals(8) || isStatic.equals(8) || isFinalStatic.equals(8) || isProtectedStatic.equals(8);
    }

    private boolean isFinal(int flag) {
        Integer isPublicFinal = flag - 1;
        Integer isPrivateFinal = flag - 2;
        Integer isProtectedFinal = flag - 4;
        Integer isFinal = flag;
        return isPublicFinal.equals(16) || isPrivateFinal.equals(16) || isProtectedFinal.equals(16) || isFinal.equals(16);
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        block15: {
            if (unit == null) break block15;
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    block16: {
                        IType type = iTypeArray[n2];
                        IAnnotation[] allAnnotations = type.getAnnotations();
                        IAnnotation EntityAnnotation = null;
                        IAnnotation[] iAnnotationArray = allAnnotations;
                        int n3 = allAnnotations.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IAnnotation annotation = iAnnotationArray[n4];
                            if (PersistenceEntityDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.persistence.Entity")) {
                                EntityAnnotation = annotation;
                            }
                            ++n4;
                        }
                        if (EntityAnnotation == null) break block16;
                        boolean hasPublicOrProtectedNoArgConstructor = false;
                        boolean hasArgConstructor = false;
                        boolean isEntityClassFinal = false;
                        IMethod[] iMethodArray = type.getMethods();
                        int n5 = iMethodArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            block19: {
                                IMethod method;
                                block17: {
                                    block18: {
                                        method = iMethodArray[n6];
                                        if (!PersistenceEntityDiagnosticsCollector.isConstructorMethod(method)) break block17;
                                        if (method.getNumberOfParameters() <= 0) break block18;
                                        hasArgConstructor = true;
                                        break block19;
                                    }
                                    if (method.getFlags() != 1 && method.getFlags() != 4) break block19;
                                    hasPublicOrProtectedNoArgConstructor = true;
                                }
                                if (this.isFinal(method.getFlags())) {
                                    diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, "A class using the @Entity annotation cannot contain any methods that are declared final", "RemoveFinalMethods", method.getElementType(), DiagnosticSeverity.Error));
                                }
                            }
                            ++n6;
                        }
                        iMethodArray = type.getFields();
                        n5 = iMethodArray.length;
                        n6 = 0;
                        while (n6 < n5) {
                            IMethod field = iMethodArray[n6];
                            if (!this.isStatic(field.getFlags()) && this.isFinal(field.getFlags())) {
                                diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, "A class using the @Entity annotation cannot contain any persistent instance variables that are declared final", "RemoveFinalVariables", field.getElementType(), DiagnosticSeverity.Error));
                            }
                            ++n6;
                        }
                        if (this.isFinal(type.getFlags())) {
                            isEntityClassFinal = true;
                        }
                        if (!hasPublicOrProtectedNoArgConstructor && hasArgConstructor) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "A class using the @Entity annotation must contain a public or protected constructor with no arguments.", "MissingEmptyConstructor", null, DiagnosticSeverity.Error));
                        }
                        if (isEntityClassFinal) {
                            diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "A class using the @Entity annotation must not be final.", "InvalidClass", type.getElementType(), DiagnosticSeverity.Error));
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate persistence diagnostics", e);
            }
        }
    }
}

