/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.servlet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ModifyAnnotationProposal;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix.InsertAnnotationMissingQuickFix;

public class CompleteFilterAnnotationQuickFix
extends InsertAnnotationMissingQuickFix {
    public CompleteFilterAnnotationQuickFix() {
        super("jakarta.servlet.annotation.WebFilter");
    }

    @Override
    protected void insertAnnotations(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        String[] annotations;
        String[] stringArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            CompleteFilterAnnotationQuickFix.insertAndReplaceAnnotation(diagnostic, context, parentType, codeActions, annotation);
            ++n2;
        }
    }

    private static void insertAndReplaceAnnotation(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String annotation) throws CoreException {
        CodeAction codeAction;
        ModifyAnnotationProposal proposal;
        String name;
        String attribute;
        int i;
        ArrayList<String> attributes;
        if (((String)diagnostic.getCode().getLeft()).equals("CompleteWebFilterAttributes")) {
            attributes = new ArrayList<String>();
            attributes.add("value");
            attributes.add("urlPatterns");
            attributes.add("servletNames");
            i = 0;
            while (i < attributes.size()) {
                attribute = (String)attributes.get(i);
                ArrayList<String> attributesToAdd = new ArrayList<String>();
                attributesToAdd.add(attribute);
                name = CompleteFilterAnnotationQuickFix.getLabel(annotation, attribute, "Add");
                proposal = new ModifyAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, attributesToAdd);
                codeAction = context.convertToCodeAction(proposal, diagnostic);
                codeAction.setTitle(name);
                if (codeAction != null) {
                    codeActions.add(codeAction);
                }
                ++i;
            }
        }
        if (((String)diagnostic.getCode().getLeft()).equals("InvalidWebFilterAttribute")) {
            attributes = new ArrayList();
            attributes.add("value");
            attributes.add("urlPatterns");
            i = 0;
            while (i < attributes.size()) {
                attribute = (String)attributes.get(i);
                ArrayList<String> attributesToRemove = new ArrayList<String>();
                attributesToRemove.add(attribute);
                name = CompleteFilterAnnotationQuickFix.getLabel(annotation, attribute, "Remove");
                proposal = new ModifyAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, new ArrayList<String>(), attributesToRemove);
                codeAction = context.convertToCodeAction(proposal, diagnostic);
                codeAction.setTitle(name);
                if (codeAction != null) {
                    codeActions.add(codeAction);
                }
                ++i;
            }
        }
    }

    private static String getLabel(String annotation, String attribute, String labelType) {
        StringBuilder name = new StringBuilder("Add the `" + attribute + "` attribute to ");
        if (labelType.equals("Remove")) {
            name = new StringBuilder("Remove the `" + attribute + "` attribute from ");
        }
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        name.append("@");
        name.append(annotationName);
        return name.toString();
    }
}

