/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.junit.Ignore;
import org.junit.Test;

public class GenerateAllPropertiesAndDefinition
extends BasePropertiesManagerTest {
    private static final Logger LOGGER = Logger.getLogger(GenerateAllPropertiesAndDefinition.class.getName());

    @Test
    @Ignore
    public void generateAllQuarkusExtensionProperties() throws JavaModelException, CoreException, Exception {
        this.generateJsonFiles(BasePropertiesManagerTest.MavenProjectName.all_quarkus_extensions, JDT_UTILS, false);
    }

    @Test
    @Ignore
    public void generateAllQuarkusExtensionPropertiesAndDefinitions() throws JavaModelException, CoreException, Exception {
        this.generateJsonFiles(BasePropertiesManagerTest.MavenProjectName.all_quarkus_extensions, JDT_UTILS, true);
    }

    private void generateJsonFiles(BasePropertiesManagerTest.MavenProjectName mavenProject, IJDTUtils utils, boolean generateDefinition) throws JavaModelException, CoreException, Exception {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory()).setPrettyPrinting().create();
        long start = System.currentTimeMillis();
        LOGGER.info("Start generating all-quarkus-properties.json");
        IJavaProject javaProject = GenerateAllPropertiesAndDefinition.loadMavenProject(mavenProject);
        MicroProfileProjectInfo info = PropertiesManager.getInstance().getMicroProfileProjectInfo(javaProject, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, ClasspathKind.SRC, utils, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
        String baseDir = "../../microprofile.ls/org.eclipse.lsp4mp.ls/src/test/resources/com/redhat/microprofile/services/";
        String propertiesAsJson = gson.toJson((Object)info);
        Files.write(Paths.get(String.valueOf(baseDir) + "all-quarkus-properties.json", new String[0]), propertiesAsJson.getBytes(), new OpenOption[0]);
        LOGGER.info("End generating all-quarkus-properties.json in " + (System.currentTimeMillis() - start) + "ms");
        if (generateDefinition) {
            IJavaProject fakeJavaProject = PropertiesManager.getInstance().configureSearchClasspath(javaProject, true, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, (IProgressMonitor)new NullProgressMonitor());
            start = System.currentTimeMillis();
            LOGGER.info("Start generating all-quarkus-definitions.json");
            GenerateAllPropertiesAndDefinition.enableClassFileContentsSupport();
            long definitionsCount = (long)info.getProperties().size() + info.getHints().stream().map(hint -> hint.getValues().size()).count();
            ArrayList<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
            AtomicLong current = new AtomicLong(0L);
            for (ItemMetadata item : info.getProperties()) {
                String sourceType = item.getSourceType();
                String sourceField = item.getSourceField();
                String sourceMethod = item.getSourceMethod();
                definitions.add(GenerateAllPropertiesAndDefinition.createDefinition(fakeJavaProject, sourceType, sourceField, sourceMethod, utils, current, definitionsCount));
            }
            for (ItemHint hint2 : info.getHints()) {
                for (ItemHint.ValueHint value : hint2.getValues()) {
                    String sourceType = this.getSourceType(value.getSourceType() != null ? value.getSourceType() : hint2.getSourceType());
                    String sourceField = value.getValue();
                    String sourceMethod = null;
                    definitions.add(GenerateAllPropertiesAndDefinition.createDefinition(fakeJavaProject, sourceType, sourceField, sourceMethod, utils, current, definitionsCount));
                }
            }
            String definitionsAsJson = gson.toJson(definitions);
            Files.write(Paths.get(String.valueOf(baseDir) + "all-quarkus-definitions.json", new String[0]), definitionsAsJson.getBytes(), new OpenOption[0]);
            LOGGER.info("End generating all-quarkus-definitions.json in " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    private String getSourceType(String sourceType) {
        if (sourceType == null) {
            return sourceType;
        }
        String type = JDTTypeUtils.getOptionalTypeParameter((String)sourceType);
        return type != null ? type : sourceType;
    }

    private static PropertyDefinition createDefinition(IJavaProject fakeJavaProject, String sourceType, String sourceField, String sourceMethod, IJDTUtils utils, AtomicLong current, long definitionsCount) {
        LOGGER.info("Compute definition for " + sourceType + "#" + sourceField + "#" + sourceMethod + " (" + current.incrementAndGet() + "/" + definitionsCount + ")");
        PropertyDefinition definition = new PropertyDefinition();
        Location location = null;
        try {
            location = PropertiesManager.getInstance().findPropertyLocation(fakeJavaProject, sourceType, sourceField, sourceMethod, utils, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        definition.setSourceType(sourceType);
        definition.setSourceField(sourceField);
        definition.setSourceMethod(sourceMethod);
        definition.setLocation(location);
        return definition;
    }

    private static void enableClassFileContentsSupport() {
        HashMap<String, String> extendedClientCapabilities = new HashMap<String, String>();
        extendedClientCapabilities.put("classFileContentsSupport", "true");
        JavaLanguageServerPlugin.getPreferencesManager().updateClientPrefences(new ClientCapabilities(), extendedClientCapabilities);
    }

    static class PropertyDefinition {
        private String sourceType;
        private String sourceField;
        private String sourceMethod;
        private Location location;

        PropertyDefinition() {
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getSourceField() {
            return this.sourceField;
        }

        public void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public String getSourceMethod() {
            return this.sourceMethod;
        }

        public void setSourceMethod(String sourceMethod) {
            this.sourceMethod = sourceMethod;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }
}

