/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.internal.config.java.MicroProfileConfigHoverParticipant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JavaHoverTest
extends BasePropertiesManagerTest {
    private static IJavaProject javaProject;

    @After
    public void cleanup() throws JavaModelException, IOException {
        JavaHoverTest.deleteFile("application.yaml", javaProject);
        JavaHoverTest.deleteFile("application.properties", javaProject);
    }

    @Test
    public void configPropertyNameHover() throws Exception {
        javaProject = JavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        JavaHoverTest.saveFile("application.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        Hover info = this.getActualHover(new Position(14, 40), javaFileUri);
        this.assertHover("greeting.message", "hello", 14, 28, 44, info);
        info = this.getActualHover(new Position(14, 28), javaFileUri);
        this.assertHover("greeting.message", "hello", 14, 28, 44, info);
        info = this.getActualHover(new Position(14, 43), javaFileUri);
        this.assertHover("greeting.message", "hello", 14, 28, 44, info);
        info = this.getActualHover(new Position(14, 27), javaFileUri);
        Assert.assertNull((Object)info);
        info = this.getActualHover(new Position(14, 44), javaFileUri);
        Assert.assertNull((Object)info);
        info = this.getActualHover(new Position(17, 33), javaFileUri);
        this.assertHover("greeting.suffix", "!", 17, 28, 43, info);
        info = this.getActualHover(new Position(26, 33), javaFileUri);
        this.assertHover("greeting.number", "100", 26, 28, 43, info);
        info = this.getActualHover(new Position(23, 33), javaFileUri);
        this.assertHover("greeting.missing", null, 23, 28, 44, info);
    }

    @Test
    public void configPropertyNameYaml() throws Exception {
        javaProject = JavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        JavaHoverTest.saveFile("application.yaml", "greeting:\n  message: message from yaml\n  number: 2001", javaProject);
        JavaHoverTest.saveFile("application.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        Hover info = this.getActualHover(new Position(14, 40), javaFileUri);
        this.assertHover("greeting.message", "message from yaml", 14, 28, 44, info);
        info = this.getActualHover(new Position(26, 33), javaFileUri);
        this.assertHover("greeting.number", "2001", 26, 28, 43, info);
        JavaHoverTest.saveFile("application.yaml", "greeting:\n  message: message from yaml", javaProject);
        info = this.getActualHover(new Position(26, 33), javaFileUri);
        this.assertHover("greeting.number", "100", 26, 28, 43, info);
    }

    @Test
    public void configPropertyNameMethod() throws Exception {
        javaProject = JavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingMethodResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        JavaHoverTest.saveFile("application.properties", "greeting.method.message = hello", javaProject);
        Hover info = this.getActualHover(new Position(22, 61), javaFileUri);
        this.assertHover("greeting.method.message", "hello", 22, 51, 74, info);
        info = this.getActualHover(new Position(27, 60), javaFileUri);
        this.assertHover("greeting.method.suffix", "!", 27, 50, 72, info);
        info = this.getActualHover(new Position(32, 58), javaFileUri);
        this.assertHover("greeting.method.name", null, 32, 48, 68, info);
    }

    @Test
    public void configPropertyNameConstructor() throws Exception {
        javaProject = JavaHoverTest.loadMavenProject(BasePropertiesManagerTest.MavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingConstructorResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        JavaHoverTest.saveFile("application.properties", "greeting.constructor.message = hello", javaProject);
        Hover info = this.getActualHover(new Position(23, 48), javaFileUri);
        this.assertHover("greeting.constructor.message", "hello", 23, 36, 64, info);
        info = this.getActualHover(new Position(24, 48), javaFileUri);
        this.assertHover("greeting.constructor.suffix", "!", 24, 36, 63, info);
        info = this.getActualHover(new Position(25, 48), javaFileUri);
        this.assertHover("greeting.constructor.name", null, 25, 36, 61, info);
    }

    private Hover getActualHover(Position hoverPosition, String javaFileUri) throws JavaModelException {
        MicroProfileJavaHoverParams params = new MicroProfileJavaHoverParams();
        params.setDocumentFormat(DocumentFormat.Markdown);
        params.setPosition(hoverPosition);
        params.setUri(javaFileUri);
        return PropertiesManagerForJava.getInstance().hover(params, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
    }

    private void assertHover(String expectedKey, String expectedValue, int expectedLine, int expectedStartOffset, int expectedEndOffset, Hover actualInfo) {
        Assert.assertNotNull((Object)actualInfo);
        Position expectedStart = new Position(expectedLine, expectedStartOffset);
        Position expectedEnd = new Position(expectedLine, expectedEndOffset);
        Range expectedRange = new Range(expectedStart, expectedEnd);
        MarkupContent expectedContent = MicroProfileConfigHoverParticipant.getDocumentation((String)expectedKey, (String)expectedValue, (DocumentFormat)DocumentFormat.Markdown, (boolean)true);
        Assert.assertEquals((Object)expectedContent, (Object)actualInfo.getContents().getRight());
        Assert.assertEquals((Object)expectedRange, (Object)actualInfo.getRange());
    }
}

