/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.corrections.proposal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.NewAnnotationProposal;

public class ReplaceAnnotationProposal
extends NewAnnotationProposal {
    private final String[] removeAnnotations;

    public ReplaceAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String annotation, String ... removeAnnotations) {
        super(label, targetCU, invocationNode, binding, relevance, annotation);
        this.removeAnnotations = removeAnnotations;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit fInvocationNode = this.getInvocationNode();
        IBinding fBinding = this.getBinding();
        String[] annotations = this.getAnnotations();
        ASTNode declNode = null;
        ASTNode boundNode = fInvocationNode.findDeclaringNode(fBinding);
        CompilationUnit newRoot = fInvocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(fBinding.getKey());
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        boolean isField = declNode instanceof VariableDeclarationFragment;
        if (isField) {
            declNode = declNode.getParent();
        }
        if (declNode instanceof TypeDeclaration || isField) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            List children = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS2_PROPERTY);
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                boolean containsAnnotation = Arrays.stream(this.removeAnnotations).anyMatch(annotationBinding.getName()::contains);
                if (!containsAnnotation) continue;
                rewrite.remove(child, null);
            }
            String[] stringArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                MarkerAnnotation marker = ast.newMarkerAnnotation();
                marker.setTypeName(ast.newName(imports.addImport(annotation, (ImportRewrite.ImportRewriteContext)importRewriteContext)));
                rewrite.getListRewrite(declNode, isField ? FieldDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
                ++n2;
            }
            return rewrite;
        }
        return null;
    }
}

