/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.restclient.properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;

public class MicroProfileRegisterRestClientProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.rest.client.inject.RegisterRestClient"};
    private static final String MP_REST_CLIENT_CLASS_REFERENCE_TYPE = "${mp.register.rest.client.class}";
    private static final String MP_REST_ADDED = MicroProfileRegisterRestClientProvider.class.getName() + "#mp-rest";

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation registerRestClientAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() == 7) {
            IPropertiesCollector collector = context.getCollector();
            if (context.get(MP_REST_ADDED) == null) {
                String docs = "The base URL to use for this service, the equivalent of the `baseUrl` method.\r\nThis property (or */mp-rest/uri) is considered required, however implementations may have other ways to define these URLs/URIs.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/url", "java.lang.String", docs, null, null, null, null, null, false);
                docs = "The base URI to use for this service, the equivalent of the baseUri method.\r\nThis property (or */mp-rest/url) is considered required, however implementations may have other ways to define these URLs/URIs.This property will override any `baseUri` value specified in the `@RegisterRestClient` annotation.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/uri", "java.lang.String", docs, null, null, null, null, null, false);
                docs = "The fully qualified classname to a CDI scope to use for injection, defaults to `javax.enterprise.context.Dependent`.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/scope", "java.lang.String", docs, null, null, null, null, null, false);
                docs = "A comma separated list of fully-qualified provider classnames to include in the client, the equivalent of the `register` method or the `@RegisterProvider` annotation.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/providers", "java.lang.String", docs, null, null, null, null, null, false);
                docs = "Override the priority of the provider for the given interface.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/providers/{*}/priority", "int", docs, null, null, null, null, null, false);
                docs = "Timeout specified in milliseconds to wait to connect to the remote endpoint.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/connectTimeout", "long", docs, null, null, null, null, null, false);
                docs = "Timeout specified in milliseconds to wait for a response from the remote endpoint.";
                super.addItemMetadata(collector, "${mp.register.rest.client.class}/mp-rest/readTimeout", "long", docs, null, null, null, null, null, false);
                context.put(MP_REST_ADDED, Boolean.TRUE);
            }
            IType type = (IType)javaElement;
            ItemHint itemHint = collector.getItemHint(MP_REST_CLIENT_CLASS_REFERENCE_TYPE);
            if (!type.isBinary()) {
                itemHint.setSource(Boolean.TRUE);
            }
            ValueHint value = new ValueHint();
            String classOrConfigKey = AnnotationUtils.getAnnotationMemberValue(registerRestClientAnnotation, "configKey");
            if (classOrConfigKey == null) {
                classOrConfigKey = type.getFullyQualifiedName();
            }
            value.setValue(classOrConfigKey);
            value.setSourceType(type.getFullyQualifiedName());
            itemHint.getValues().add(value);
        }
    }
}

