/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.config.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

public class MicroProfileConfigJavaHoverTest
extends BasePropertiesManagerTest {
    private static IJavaProject javaProject;

    @BeforeClass
    public static void setupProject() throws Exception {
        MicroProfileConfigJavaHoverTest.loadJavaProjects(new String[]{"maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover, "maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart});
    }

    @After
    public void cleanup() throws Exception {
        MicroProfileConfigJavaHoverTest.deleteFile("META-INF/microprofile-config.properties", javaProject);
        MicroProfileConfigJavaHoverTest.deleteFile("META-INF/microprofile-config-test.properties", javaProject);
        MicroProfileConfigJavaHoverTest.deleteFile("META-INF/config.properties", javaProject);
    }

    @Test
    public void configPropertyNameHover() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = hello\r\ngreeting.name = quarkus\r\ngreeting.number = 100", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 28), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 43), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 27), javaFileUri, JDT_UTILS, null);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 44), javaFileUri, JDT_UTILS, null);
        MicroProfileForJavaAssert.assertJavaHover(new Position(17, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.suffix = !` *in* [GreetingResource.java](" + javaFileUri + ")", 17, 28, 43));
        MicroProfileForJavaAssert.assertJavaHover(new Position(29, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.number = 100` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 29, 28, 43));
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 33), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.missing` is not set", 23, 28, 44));
    }

    @Test
    public void configPropertyNameHoverWithProfiles() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = hello\r\n%dev.greeting.message = hello dev\r\n%prod.greeting.message = hello prod\r\nmy.greeting.message\r\n%dev.my.greeting.message", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`%dev.greeting.message = hello dev` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")  \n`%prod.greeting.message = hello prod` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")  \n`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "%dev.greeting.message = hello dev\r\n%prod.greeting.message = hello prod\r\nmy.greeting.message\r\n%dev.my.greeting.message", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`%dev.greeting.message = hello dev` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")  \n`%prod.greeting.message = hello prod` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")  \n`greeting.message` is not set", 14, 28, 44));
    }

    @Test
    public void configPropertyNameMethod() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingMethodResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.method.message = hello", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(22, 61), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 22, 51, 74));
        MicroProfileForJavaAssert.assertJavaHover(new Position(27, 60), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.suffix = !` *in* [GreetingMethodResource.java](" + javaFileUri + ")", 27, 50, 72));
        MicroProfileForJavaAssert.assertJavaHover(new Position(32, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.method.name` is not set", 32, 48, 68));
    }

    @Test
    public void configPropertyNameConstructor() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingConstructorResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.constructor.message = hello", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(23, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 23, 36, 64));
        MicroProfileForJavaAssert.assertJavaHover(new Position(24, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.suffix = !` *in* [GreetingConstructorResource.java](" + javaFileUri + ")", 24, 36, 63));
        MicroProfileForJavaAssert.assertJavaHover(new Position(25, 48), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.constructor.name` is not set", 25, 36, 61));
    }

    @Test
    public void configPropertyNamePrecedence() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        IFile configPropertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/config.properties"));
        String configPropertiesFileUri = MicroProfileForJavaAssert.fixURI(configPropertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = hello\r\n", javaProject);
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/config.properties", "greeting.message = hi\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hi` *in* [META-INF/config.properties](" + configPropertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/config.properties", "\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
    }

    @Test
    public void configPropertyNameProfile() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        IFile testPropertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config-test.properties"));
        String testPropertiesFileUri = MicroProfileForJavaAssert.fixURI(testPropertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = hello\r\n", javaProject);
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config-test.properties", "greeting.message = hi\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`%test.greeting.message = hi` *in* [META-INF/microprofile-config-test.properties](" + testPropertiesFileUri + ")  \n`greeting.message = hi` *in* [META-INF/microprofile-config-test.properties](" + testPropertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config-test.properties", "\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
    }

    @Test
    public void configPropertyNameResolveExpression() throws Exception {
        javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        IFile propertiesFile = project.getFile((IPath)new Path("src/main/resources/META-INF/microprofile-config.properties"));
        String propertiesFileUri = MicroProfileForJavaAssert.fixURI(propertiesFile.getLocation().toFile().toURI());
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = ${asdf}\r\nasdf = hello", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hello` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = ${${asdf}}\r\nasdf = hjkl\r\nhjkl = salutations", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = salutations` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = ${asdf:hi}\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = hi` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
        MicroProfileConfigJavaHoverTest.saveFile("META-INF/microprofile-config.properties", "greeting.message = ${asdf}\r\n", javaProject);
        MicroProfileForJavaAssert.assertJavaHover(new Position(14, 40), javaFileUri, JDT_UTILS, MicroProfileForJavaAssert.h("`greeting.message = ${asdf}` *in* [META-INF/microprofile-config.properties](" + propertiesFileUri + ")", 14, 28, 44));
    }
}

