/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.properties;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.config.properties.MicroProfileConfigPropertyProvider;

public class MicroProfileConfigPropertiesProvider
extends MicroProfileConfigPropertyProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.config.inject.ConfigProperties"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation configPropertiesAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 7: {
                this.generatePropertiesFromClassType((IType)javaElement, configPropertiesAnnotation, context, monitor);
                break;
            }
            case 8: {
                this.generatePropertiesFromField((IField)javaElement, configPropertiesAnnotation, context, monitor);
            }
        }
    }

    private void generatePropertiesFromClassType(IType classType, IAnnotation configPropertiesAnnotation, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        String prefix = MicroProfileConfigPropertiesProvider.getPrefixFromAnnotation(configPropertiesAnnotation);
        this.populateConfigObject(classType, prefix, new HashSet<IType>(), context.getCollector(), monitor);
    }

    private void generatePropertiesFromField(IField field, IAnnotation configPropertiesAnnotation, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        String fieldTypeName = JDTTypeUtils.getResolvedTypeName(field);
        IType fieldType = JDTTypeUtils.findType(field.getJavaProject(), fieldTypeName);
        if (JDTTypeUtils.isSimpleFieldType(fieldType, fieldTypeName)) {
            return;
        }
        String prefix = MicroProfileConfigPropertiesProvider.getPrefixFromAnnotation(configPropertiesAnnotation);
        if (prefix == null) {
            return;
        }
        this.populateConfigObject(fieldType, prefix, new HashSet<IType>(), context.getCollector(), monitor);
    }

    private static String getPrefixFromAnnotation(IAnnotation configPropertiesAnnotation) throws JavaModelException {
        String prefix = AnnotationUtils.getAnnotationMemberValue(configPropertiesAnnotation, "prefix");
        return prefix == null || "org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix".equals(prefix) ? null : prefix;
    }

    private void populateConfigObject(IType configPropertiesType, String prefix, Set<IType> typesAlreadyProcessed, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements;
        if (typesAlreadyProcessed.contains(configPropertiesType)) {
            return;
        }
        typesAlreadyProcessed.add(configPropertiesType);
        IJavaElement[] iJavaElementArray = elements = configPropertiesType.getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child.getElementType() == 8 || child.getElementType() == 14) {
                IAnnotation configPropertyAnnotation;
                String fieldTypeName = JDTTypeUtils.getResolvedTypeName(child);
                IType fieldClass = JDTTypeUtils.findType(child.getJavaProject(), fieldTypeName);
                if (JDTTypeUtils.isSimpleFieldType(fieldClass, fieldTypeName)) {
                    configPropertyAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)child, "org.eclipse.microprofile.config.inject.ConfigProperty");
                    super.collectProperty(child, configPropertyAnnotation, prefix, true, collector);
                } else {
                    configPropertyAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)child, "org.eclipse.microprofile.config.inject.ConfigProperty");
                    String propertyName = super.getPropertyName(child, configPropertyAnnotation, prefix, true);
                    this.populateConfigObject(fieldClass, propertyName, typesAlreadyProcessed, collector, monitor);
                }
            }
            ++n2;
        }
    }
}

