/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.health.java;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.health.java.MicroProfileHealthErrorCode;
import org.junit.Test;

public class MicroProfileHealthJavaDiagnosticsTest
extends BasePropertiesManagerTest {
    @Test
    public void ImplementHealthCheck() throws Exception {
        IJavaProject javaProject = MicroProfileHealthJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_health_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/health/DontImplementHealthCheck.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(9, 13, 37, "The class `org.acme.health.DontImplementHealthCheck` using the @Liveness, @Readiness, or @Health annotation should implement the HealthCheck interface.", DiagnosticSeverity.Warning, "microprofile-health", (IJavaErrorCode)MicroProfileHealthErrorCode.ImplementHealthCheck);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Let 'DontImplementHealthCheck' implement 'org.eclipse.microprofile.health.HealthCheck'", d, MicroProfileForJavaAssert.te(2, 50, 9, 37, "\r\n\r\nimport org.eclipse.microprofile.health.HealthCheck;\r\nimport org.eclipse.microprofile.health.HealthCheckResponse;\r\nimport org.eclipse.microprofile.health.Liveness;\r\n\r\n@Liveness\r\n@ApplicationScoped\r\npublic class DontImplementHealthCheck implements HealthCheck")));
    }

    @Test
    public void HealthAnnotationMissing() throws Exception {
        IJavaProject javaProject = MicroProfileHealthJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_health_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/health/ImplementHealthCheck.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(5, 13, 33, "The class `org.acme.health.ImplementHealthCheck` implementing the HealthCheck interface should use the @Liveness, @Readiness, or @Health annotation.", DiagnosticSeverity.Warning, "microprofile-health", (IJavaErrorCode)MicroProfileHealthErrorCode.HealthAnnotationMissing);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Insert @Health", d, MicroProfileForJavaAssert.te(2, 0, 5, 0, "import org.eclipse.microprofile.health.Health;\r\nimport org.eclipse.microprofile.health.HealthCheck;\r\nimport org.eclipse.microprofile.health.HealthCheckResponse;\r\n\r\n@Health\r\n")), MicroProfileForJavaAssert.ca(uri, "Insert @Liveness", d, MicroProfileForJavaAssert.te(3, 59, 5, 0, "\r\nimport org.eclipse.microprofile.health.Liveness;\r\n\r\n@Liveness\r\n")), MicroProfileForJavaAssert.ca(uri, "Insert @Readiness", d, MicroProfileForJavaAssert.te(3, 59, 5, 0, "\r\nimport org.eclipse.microprofile.health.Readiness;\r\n\r\n@Readiness\r\n")));
    }
}

