/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.graphql.java;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.graphql.java.MicroProfileGraphQLErrorCode;

public class MicroProfileGraphQLASTValidator
extends JavaASTValidator {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileGraphQLASTValidator.class.getName());
    private static final String NO_VOID_QUERY_MESSAGE = "Methods annotated with microprofile-graphql's `@Query` cannot have 'void' as a return type.";
    private static final String NO_VOID_MUTATION_MESSAGE = "Methods annotated with microprofile-graphql's `@Mutation` cannot have 'void' as a return type.";
    private static final String GRAPH_QL_API_ANNOTATION_MESSAGE = "Annotate ''{0}'' with ''@GraphQLApi'' in order for microprofile-graphql to recognize ''{1}'' as a part of the GraphQL API.";

    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.graphql.Query") != null;
    }

    public boolean visit(MethodDeclaration node) {
        try {
            this.validateMethod(node);
        }
        catch (JavaModelException javaModelException) {
            LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation marked method");
        }
        super.visit(node);
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        try {
            this.validateTypeDeclaration(node);
        }
        catch (JavaModelException javaModelException) {
            LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the type");
        }
        super.visit(node);
        return true;
    }

    private void validateMethod(MethodDeclaration node) throws JavaModelException {
        List modifiers = node.modifiers();
        for (Object modifier : modifiers) {
            Type returnType;
            if (!(modifier instanceof Annotation)) continue;
            Annotation annotation = (Annotation)modifier;
            if (AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.graphql.Query")) {
                returnType = node.getReturnType2();
                if (!returnType.isPrimitiveType() || !PrimitiveType.VOID.equals(((PrimitiveType)returnType).getPrimitiveTypeCode())) continue;
                super.addDiagnostic(NO_VOID_QUERY_MESSAGE, "microprofile-graphql", (ASTNode)returnType, MicroProfileGraphQLErrorCode.NO_VOID_QUERIES, DiagnosticSeverity.Error);
                continue;
            }
            if (!AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.graphql.Mutation") || !(returnType = node.getReturnType2()).isPrimitiveType() || !PrimitiveType.VOID.equals(((PrimitiveType)returnType).getPrimitiveTypeCode())) continue;
            super.addDiagnostic(NO_VOID_MUTATION_MESSAGE, "microprofile-graphql", (ASTNode)returnType, MicroProfileGraphQLErrorCode.NO_VOID_MUTATIONS, DiagnosticSeverity.Error);
        }
    }

    private void validateTypeDeclaration(TypeDeclaration node) throws JavaModelException {
        if (!this.hasGraphQLApiAnnotation((AbstractTypeDeclaration)node)) {
            MethodDeclaration[] methodDeclarationArray = node.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration method = methodDeclarationArray[n2];
                if (this.hasGraphQLMethodAnnotation(method)) {
                    String message = MessageFormat.format(GRAPH_QL_API_ANNOTATION_MESSAGE, node.getName(), method.getName());
                    super.addDiagnostic(message, "microprofile-graphql", (ASTNode)node.getName(), MicroProfileGraphQLErrorCode.MISSING_GRAPHQL_API_ANNOTATION, DiagnosticSeverity.Warning);
                    break;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasGraphQLApiAnnotation(AbstractTypeDeclaration node) {
        for (Object modifier : node.modifiers()) {
            void annotation;
            Annotation annotation2;
            Object e = modifier;
            if (!(e instanceof Annotation) || (annotation2 = (Annotation)e) != (Annotation)e || !AnnotationUtils.isMatchAnnotation((Annotation)annotation, "org.eclipse.microprofile.graphql.GraphQLApi")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasGraphQLMethodAnnotation(MethodDeclaration node) {
        for (Object modifier : node.modifiers()) {
            void annotation;
            Annotation annotation2;
            Object e = modifier;
            if (!(e instanceof Annotation) || (annotation2 = (Annotation)e) != (Annotation)e || !AnnotationUtils.isMatchAnnotation((Annotation)annotation, "org.eclipse.microprofile.graphql.Query") && !AnnotationUtils.isMatchAnnotation((Annotation)annotation, "org.eclipse.microprofile.graphql.Mutation")) continue;
            return true;
        }
        return false;
    }
}

