/*
 * Copyright (c) 2016-2017 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.eclipse.microprofile.config.tck.converters;

import org.eclipse.microprofile.config.spi.Converter;

import jakarta.annotation.Priority;

/**
 * Always create a duck with an upper case name
 *
 * @author <a href="http://jmesnil.net/">Jeff Mesnil</a>
 */
@Priority(101)
public class UpperCaseDuckConverter implements Converter<Duck> {
    @Override
    public Duck convert(String value) {
        return new Duck(value.toUpperCase());
    }
}
