/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic.execution;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.eclipse.microprofile.graphql.tck.dynamic.execution.TestData;

public class PrintUtil {
    private static final Logger LOG = Logger.getLogger(PrintUtil.class.getName());
    private static final String FS = System.getProperty("file.separator");

    private PrintUtil() {
    }

    public static void toDisk(TestData testData, String output, Throwable throwable) {
        try {
            String log = PrintUtil.toString(testData, output, throwable);
            PrintUtil.writeTestFile(testData.getName(), log);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not save data to target folder - {0}", ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String toString(TestData testData, String output, Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            sw.write("============= " + testData.getName() + " =============");
            sw.write("\n\n");
            if (throwable != null) {
                sw.write("errorMessage = " + throwable.getMessage());
            } else {
                sw.write("errorMessage = ");
            }
            sw.write("\n\n");
            if (testData.getInput().size() == 1) {
                sw.write("given input = " + testData.getInput().iterator().next());
            } else {
                sw.write("given multiple inputs = \n");
                testData.getInput().stream().forEach(i -> sw.write(i + "\n"));
            }
            sw.write("\n\n");
            sw.write("variables input = " + PrintUtil.prettyJson(testData.getVariables()));
            sw.write("\n\n");
            sw.write("http headers input = " + testData.getHttpHeaders());
            sw.write("\n\n");
            if (testData.getOutput().size() == 1) {
                sw.write("expected output = " + PrintUtil.prettyJson(testData.getOutput().iterator().next()));
            } else {
                sw.write("expected output was either of the following = " + String.join((CharSequence)"\nOR\n", testData.getOutput()));
            }
            sw.write("\n\n");
            sw.write("received output = " + PrintUtil.prettyJson(output));
            sw.write("\n\n");
            String string = sw.toString();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeTestFile(String testName, String data) throws IOException {
        if (data != null && !data.isEmpty()) {
            Path file = Paths.get("target" + FS + testName + ".log", new String[0]);
            Path createFile = Files.createFile(file, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(createFile, Charset.forName("UTF-8"), new OpenOption[0]);){
                writer.write(data);
            }
        }
    }

    private static String prettyJson(String json) {
        if (json != null) {
            JsonReader jr = Json.createReader((Reader)new StringReader(json));
            JsonObject jobj = jr.readObject();
            return PrintUtil.prettyJson(jobj);
        }
        return null;
    }

    private static String prettyJson(JsonObject jsonObject) {
        if (jsonObject != null) {
            StringWriter sw = new StringWriter();
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(properties);
            try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
                jsonWriter.writeObject(jsonObject);
            }
            return sw.toString();
        }
        return null;
    }
}

