/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic.execution;

import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.json.JsonObject;

public class TestData {
    private String name;
    private Set<String> input;
    private Properties httpHeaders;
    private Set<String> output;
    private JsonObject variables;
    private String prepare;
    private String cleanup;
    private Properties properties;

    public TestData() {
    }

    public TestData(String name) {
        this.name = name;
        this.output = new HashSet<String>();
        this.input = new HashSet<String>();
    }

    public TestData(String name, Set<String> input, Properties httpHeaders, Set<String> output, JsonObject variables, String prepare, String cleanup, Properties properties) {
        this.name = name;
        this.input = input;
        this.httpHeaders = httpHeaders;
        this.output = output;
        this.variables = variables;
        this.prepare = prepare;
        this.cleanup = cleanup;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getInput() {
        return this.input;
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public Set<String> getOutput() {
        return this.output;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public String getPrepare() {
        return this.prepare;
    }

    public String getCleanup() {
        return this.cleanup;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInput(Set<String> input) {
        this.input = input;
    }

    public void addInput(String input) {
        this.input.add(input);
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setOutput(Set<String> output) {
        this.output = output;
    }

    public void addOutput(String output) {
        this.output.add(output);
    }

    public void setVariables(JsonObject variables) {
        this.variables = variables;
    }

    public void setPrepare(String prepare) {
        this.prepare = prepare;
    }

    public void setCleanup(String cleanup) {
        this.cleanup = cleanup;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean shouldIgnore() {
        return this.getBooleanProperty("ignore");
    }

    public Integer getPriority() {
        if (this.properties != null && !this.properties.isEmpty() && this.properties.containsKey("priority")) {
            return Integer.valueOf(this.properties.getProperty("priority"));
        }
        return 999;
    }

    public int getExpectedHttpStatusCode() {
        if (this.properties != null && !this.properties.isEmpty() && this.properties.containsKey("expectedHttpStatusCode")) {
            return Integer.valueOf(this.properties.getProperty("expectedHttpStatusCode"));
        }
        return 200;
    }

    public boolean beStrict() {
        return this.getBooleanProperty("strict");
    }

    public String getFailMessage() {
        if (this.properties != null && !this.properties.isEmpty() && this.properties.containsKey("failMessage")) {
            return this.properties.getProperty("failMessage");
        }
        return this.getName() + " failed";
    }

    private boolean getBooleanProperty(String key) {
        String ignore;
        return this.properties != null && !this.properties.isEmpty() && this.properties.containsKey(key) && (ignore = this.properties.getProperty(key)) != null && !ignore.isEmpty() && ignore.equalsIgnoreCase("true");
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.name);
        hash = 17 * hash + Objects.hashCode(this.input);
        hash = 17 * hash + Objects.hashCode(this.httpHeaders);
        hash = 17 * hash + Objects.hashCode(this.output);
        hash = 17 * hash + Objects.hashCode(this.variables);
        hash = 17 * hash + Objects.hashCode(this.prepare);
        hash = 17 * hash + Objects.hashCode(this.cleanup);
        hash = 17 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestData other = (TestData)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        if (!Objects.equals(this.output, other.output)) {
            return false;
        }
        if (!Objects.equals(this.prepare, other.prepare)) {
            return false;
        }
        if (!Objects.equals(this.cleanup, other.cleanup)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, other.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.variables, other.variables)) {
            return false;
        }
        return Objects.equals(this.properties, other.properties);
    }
}

