/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.AudienceValidationEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class AudArrayValidationTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;
    private static String token;

    @Deployment
    public static WebArchive createDeployment() throws Exception {
        URL publicKey = AudArrayValidationTest.class.getResource("/publicKey4k.pem");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "publicKey4k";
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/TokenAudiences.json", null, timeClaims);
        Properties configProps = new Properties();
        configProps.setProperty("mp.jwt.verify.publickey.location", "/publicKey4k.pem");
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        configProps.setProperty("mp.jwt.verify.audiences", "aud3,badAud,aud1");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "AudArrayValidationTest microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"AudArrayValidationTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addAsResource(publicKey, "/publicKey4k.pem")).add((Asset)new StringAsset(token), "MP-JWT")).addClass(AudienceValidationEndpoint.class)).addClass(TCKApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate that JWT with aud that is contained in mp.jwt.verify.audiences returns HTTP_OK")
    public void testRequiredAudMatch() throws Exception {
        Reporter.log((String)"testRequiredAudMatch, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/verifyAudIsOk";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

