/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.security.Principal;
import java.util.Date;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Path(value="/endp")
@DenyAll
@RequestScoped
public class RolesEndpoint {
    @Inject
    private JsonWebToken jwtPrincipal;
    @Inject
    @Claim(value="raw_token")
    private ClaimValue<String> rawToken;

    @GET
    @Path(value="/echo")
    @RolesAllowed(value={"Echoer"})
    public String echoInput(@Context SecurityContext sec, @QueryParam(value="input") String input) {
        Principal user = sec.getUserPrincipal();
        return input + ", user=" + user.getName();
    }

    @GET
    @Path(value="/echo-permit-all")
    @PermitAll
    public String echoInputPermitAll(@Context SecurityContext sec, @QueryParam(value="input") String input) {
        Principal user = sec.getUserPrincipal();
        return input + ", permitAll, user=" + user.getName();
    }

    @GET
    @Path(value="/echo2")
    @RolesAllowed(value={"NoSuchUser"})
    public String echoInput2(@Context SecurityContext sec, @QueryParam(value="input") String input) {
        Principal user = sec.getUserPrincipal();
        String name = user != null ? user.getName() : "<null>";
        return input + ", user=" + name;
    }

    @GET
    @Path(value="/echoNeedsToken2Role")
    @RolesAllowed(value={"Token2Role"})
    public String echoNeedsToken2Role(@Context SecurityContext sec, @QueryParam(value="input") String input) {
        Principal user = sec.getUserPrincipal();
        return input + ", user=" + user.getName();
    }

    @GET
    @Path(value="/getPrincipalClass")
    @RolesAllowed(value={"Tester"})
    public String getPrincipalClass(@Context SecurityContext sec) {
        Principal user = sec.getUserPrincipal();
        boolean isJsonWebToken = user instanceof JsonWebToken;
        return "isJsonWebToken:" + isJsonWebToken;
    }

    @GET
    @Path(value="/needsGroup1Mapping")
    @RolesAllowed(value={"Group1MappedRole"})
    public String needsGroup1Mapping(@Context SecurityContext sec) {
        Principal user = sec.getUserPrincipal();
        sec.isUserInRole("group1");
        return user.getName();
    }

    @GET
    @Path(value="/checkIsUserInRole")
    @RolesAllowed(value={"Tester"})
    public Response checkIsUserInRole(@Context SecurityContext sec) {
        Principal user = sec.getUserPrincipal();
        Response response = !sec.isUserInRole("Echoer") ? Response.status((Response.StatusType)new Response.StatusType(){

            public int getStatusCode() {
                return Response.Status.FORBIDDEN.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.FORBIDDEN.getFamily();
            }

            public String getReasonPhrase() {
                return "SecurityContext.isUserInRole(Echoer) was false";
            }
        }).build() : Response.ok((Object)user.getName(), (String)"text/plain").build();
        return response;
    }

    @GET
    @Path(value="/getInjectedPrincipal")
    @RolesAllowed(value={"Tester"})
    public String getInjectedPrincipal(@Context SecurityContext sec) {
        boolean isJsonWebToken = this.jwtPrincipal instanceof JsonWebToken;
        return "isJsonWebToken:" + isJsonWebToken;
    }

    @GET
    @Path(value="/heartbeat")
    @PermitAll
    public String heartbeat() {
        return "Heartbeat: " + new Date(System.currentTimeMillis()).toString();
    }
}

