/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.microprofile.jwt.tck.config.PublicKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class IssValidationFailTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;
    private static String token;

    @Deployment
    public static WebArchive createDeployment() throws Exception {
        URL publicKey = IssValidationFailTest.class.getResource("/publicKey4k.pem");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "publicKey4k";
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/RequiredClaims.json", null, timeClaims);
        Properties configProps = new Properties();
        configProps.setProperty("mp.jwt.verify.publickey.location", "/publicKey4k.pem");
        configProps.setProperty("mp.jwt.verify.issuer", "https://IssValidationFailTest");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "IssValidationFailTest microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"IssValidationFailTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addAsResource(publicKey, "/publicKey4k.pem")).add((Asset)new StringAsset(token), "MP-JWT")).addClass(PublicKeyEndpoint.class)).addClass(TCKApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate that JWK with iss that does not match mp.jwt.verify.issuer returns HTTP_UNAUTHORIZED")
    public void testNotRequiredIssMismatchFailure() throws Exception {
        Reporter.log((String)"testNotRequiredIssMismatchFailure, expect HTTP_UNAUTHORIZED");
        String uri = this.baseURL.toExternalForm() + "endp/verifyIssIsOk";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }
}

