/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.util.KeyManagementAlgorithm;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenUtilsEncryptTest {
    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of iss")
    public void testFailAlgorithm() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ALG);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of an encrypted JWT with RSA-OAEP")
    public void testValidTokenWithRSAOAEP() throws Exception {
        String token = TokenUtils.encryptClaims((String)"/Token1.json");
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of an encrypted JWT with RSA-OAEP")
    public void testValidTokenWithRsaOaep256() throws Exception {
        RSAPublicKey pk = TokenUtils.readPublicKey((String)"/publicKey.pem");
        String token = TokenUtils.encryptClaims((PublicKey)pk, (KeyManagementAlgorithm)KeyManagementAlgorithm.RSA_OAEP_256, (String)"/Token1.json", (String)"/Token1.json", null, null);
        this.validateToken(token, KeyManagementAlgorithm.RSA_OAEP_256, null);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation failure if signed token is used")
    public void testValidateSignedToken() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json");
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of alg")
    public void testFailIssuer() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ISSUER);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of encryptor")
    public void testFailEncryption() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ENCRYPTOR);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of exp")
    public void testFailExpired() throws Exception {
        HashMap timeClaims = new HashMap();
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.EXP);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", invalidFields, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of exp that has just expired")
    public void testFailJustExpired() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 61;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", null, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of exp that is in grace period")
    public void testExpGrace() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 45;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.encryptClaims((String)"/Token1.json", null, timeClaims);
        this.validateToken(token, null, exp);
    }

    private void validateToken(String token) throws Exception {
        this.validateToken(token, null, null);
    }

    private void validateToken(String token, KeyManagementAlgorithm keyAlgorithm, Long expectedExpValue) throws Exception {
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        int expGracePeriodSecs = 60;
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setDisableRequireSignature();
        builder.setEnableRequireEncryption();
        builder.setRequireExpirationTime();
        builder.setSkipDefaultAudienceValidation();
        builder.setRequireIssuedAt();
        builder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{keyAlgorithm != null ? keyAlgorithm.getAlgorithm() : "RSA-OAEP"}));
        builder.setExpectedIssuer(true, "https://server.example.com");
        builder.setDecryptionKey((Key)privateKey);
        builder.setAllowedClockSkewInSeconds(expGracePeriodSecs);
        JwtClaims claimsSet = builder.build().processToClaims(token);
        Assert.assertEquals((int)claimsSet.getClaimsMap().size(), (int)19);
        Assert.assertEquals((String)claimsSet.getIssuer(), (String)"https://server.example.com");
        Assert.assertEquals((String)claimsSet.getJwtId(), (String)"a-123");
        Assert.assertEquals((String)claimsSet.getSubject(), (String)"24400320");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("upn"), (String)"jdoe@example.com");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("preferred_username"), (String)"jdoe");
        Assert.assertEquals((int)claimsSet.getAudience().size(), (int)1);
        Assert.assertEquals((String)((String)claimsSet.getAudience().get(0)), (String)"s6BhdRkqt3");
        if (expectedExpValue != null) {
            Assert.assertEquals((long)claimsSet.getExpirationTime().getValue(), (long)expectedExpValue);
            Assert.assertEquals((long)claimsSet.getIssuedAt().getValue(), (long)(expectedExpValue - 5L));
            Assert.assertEquals((long)NumericDate.fromSeconds((long)((Long)claimsSet.getClaimValue("auth_time", Long.class))).getValue(), (long)(expectedExpValue - 5L));
        } else {
            Assert.assertNotNull((Object)claimsSet.getExpirationTime());
            long exp = claimsSet.getExpirationTime().getValue();
            Assert.assertEquals((long)claimsSet.getIssuedAt().getValue(), (long)(exp - 300L));
            Assert.assertEquals((long)NumericDate.fromSeconds((long)((Long)claimsSet.getClaimValue("auth_time", Long.class))).getValue(), (long)(exp - 300L));
        }
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("customString"), (String)"customStringValue");
        Assert.assertEquals((Object)claimsSet.getClaimValue("customInteger", Long.class), (Object)123456789L);
        Assert.assertEquals((Object)claimsSet.getClaimValue("customDouble", Double.class), (Object)Math.PI);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("roles")).size(), (int)1);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("groups")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customStringArray")).size(), (int)3);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customIntegerArray")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customDoubleArray")).size(), (int)5);
        Assert.assertEquals((int)((Map)claimsSet.getClaimsMap().get("customObject")).size(), (int)3);
    }
}

