/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TagsTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void simpleTagTest() {
        Tag one = new Tag("hello", "world");
        Tag two = new Tag("goodbye", "friend");
        MetricID metricID = new MetricID("metricName", new Tag[]{one, two});
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasKey((Object)"hello"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasValue((Object)"world"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasKey((Object)"goodbye"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasValue((Object)"friend"));
    }

    @Test
    @InSequence(value=2)
    public void lastTagValueTest() {
        Tag tagColour = new Tag("colour", "red");
        Tag tagColourTwo = new Tag("colour", "blue");
        String counterName = "org.eclipse.microprofile.metrics.tck.TagTest.counter.lastTag";
        Counter counter = this.registry.counter(counterName, new Tag[]{tagColour, tagColourTwo});
        MetricID counterMID = new MetricID(counterName, new Tag[]{tagColourTwo});
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounter(counterMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=3)
    public void counterTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String counterName = "org.eclipse.microprofile.metrics.tck.TagTest.counterColour";
        String counterNameNoTag = "org.eclipse.microprofile.metrics.tck.TagTest.counter";
        Counter counter = this.registry.counter(counterNameNoTag);
        Counter counterRed = this.registry.counter(counterName, new Tag[]{tagEarth, tagRed});
        Counter counterBlue = this.registry.counter(counterName, new Tag[]{tagEarth, tagBlue});
        MetricID counterColourMID = new MetricID(counterNameNoTag);
        MetricID counterRedMID = new MetricID(counterName, new Tag[]{tagEarth, tagRed});
        MetricID counterBlueMID = new MetricID(counterName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounter(counterColourMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounter(counterRedMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounter(counterBlueMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=4)
    public void timerTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String timerName = "org.eclipse.microprofile.metrics.tck.TagTest.timerColour";
        String timerNameNoTag = "org.eclipse.microprofile.metrics.tck.TagTest.timer";
        Timer timerColour = this.registry.timer(timerNameNoTag);
        Timer timerRed = this.registry.timer(timerName, new Tag[]{tagEarth, tagRed});
        Timer timerBlue = this.registry.timer(timerName, new Tag[]{tagEarth, tagBlue});
        MetricID timerColourMID = new MetricID(timerNameNoTag);
        MetricID timerRedMID = new MetricID(timerName, new Tag[]{tagEarth, tagRed});
        MetricID timerBlueMID = new MetricID(timerName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimer(timerColourMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimer(timerRedMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimer(timerBlueMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=5)
    public void histogramTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String histogramName = "org.eclipse.microprofile.metrics.tck.TagTest.histogramColour";
        String histogramNameNoTag = "org.eclipse.microprofile.metrics.tck.TagTest.histogram";
        Histogram histogramColour = this.registry.histogram(histogramNameNoTag);
        Histogram histogramRed = this.registry.histogram(histogramName, new Tag[]{tagEarth, tagRed});
        Histogram histogramBlue = this.registry.histogram(histogramName, new Tag[]{tagEarth, tagBlue});
        MetricID histogramColourMID = new MetricID(histogramNameNoTag);
        MetricID histogramRedMID = new MetricID(histogramName, new Tag[]{tagEarth, tagRed});
        MetricID histogramBlueMID = new MetricID(histogramName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramColourMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramRedMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramBlueMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=6)
    public void nonMatchingTagTest() {
        Tag tagForNames = new Tag("name", "Bill");
        String counterName = "org.eclipse.microprofile.metrics.tck.TagTest.counter.mismatch.tags";
        Counter counter = this.registry.counter(counterName);
        try {
            this.registry.counter(counterName, new Tag[]{tagForNames});
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
            return;
        }
        Assert.fail((String)"No exception was caught");
    }

    @Test
    @InSequence(value=7)
    public void nonMatchingTagTest2() {
        Tag tagForNames = new Tag("name", "Bill");
        Tag tagForAnimals = new Tag("animal", "dog");
        String timerName = "org.eclipse.microprofile.metrics.tck.TagTest.timer.mismatch.tags";
        Timer timer = this.registry.timer(timerName, new Tag[]{tagForNames});
        try {
            this.registry.timer(timerName, new Tag[]{tagForAnimals});
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
            return;
        }
        Assert.fail((String)"No exception was caught");
    }

    @Test
    @InSequence(value=8)
    public void nonMatchingTagTest3() {
        Tag tagForNames = new Tag("name", "Bill");
        Tag tagForAnimals = new Tag("animal", "dog");
        String histogramName = "org.eclipse.microprofile.metrics.tck.TagTest.histogram.mismatch.tags";
        Histogram histogram = this.registry.histogram(histogramName, new Tag[]{tagForNames});
        try {
            this.registry.histogram(histogramName, new Tag[]{tagForAnimals});
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
            return;
        }
        Assert.fail((String)"No exception was caught");
    }

    @Test
    @InSequence(value=9)
    public void illegalMpScopeTag() {
        Tag mpScopeTag = new Tag("mp_scope", "aScope");
        try {
            this.registry.histogram("someHistogram", new Tag[]{mpScopeTag});
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
            return;
        }
        Assert.fail((String)"No exception was caught");
    }

    @Test
    @InSequence(value=10)
    public void illegalMpAppTag() {
        Tag mpAppTag = new Tag("mp_app", "anApp");
        try {
            this.registry.counter("someCounter", new Tag[]{mpAppTag});
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
            return;
        }
        Assert.fail((String)"No exception was caught");
    }
}

