/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricRegistryTest {
    private static final String CUSTOM_SCOPE = "customScope";
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="nameTest", absolute=true)
    private Counter nameTest;
    @Inject
    private MetricRegistry metrics;
    @Inject
    @RegistryScope(scope="base")
    private MetricRegistry baseMetrics;
    @Inject
    @RegistryScope(scope="vendor")
    private MetricRegistry vendorMetrics;
    @Inject
    @RegistryScope(scope="customScope")
    private MetricRegistry customScope;
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    private MetricRegistry baseMetrics_RegistryType;
    @Inject
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    private MetricRegistry vendorMetrics_RegistryType;
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    private MetricRegistry applicationMetrics_RegistryType;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void nameTest() {
        Assert.assertNotNull((Object)this.metrics);
        Assert.assertNotNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=3)
    public void removeTest() {
        this.metrics.remove("nameTest");
        Assert.assertNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=4)
    public void useExistingMetaDataTest() {
        String metricName = "counterFoo";
        Tag orangeTag = new Tag("colour", "orange");
        Tag purpleTag = new Tag("colour", "purple");
        this.metrics.counter(Metadata.builder().withName(metricName).build(), new Tag[]{orangeTag});
        this.metrics.counter(metricName, new Tag[]{purpleTag});
        this.assertExists(Counter.class, new MetricID(metricName, new Tag[]{orangeTag}));
        this.assertExists(Counter.class, new MetricID(metricName, new Tag[]{purpleTag}));
    }

    @Test
    @InSequence(value=5)
    public void testMetricRegistryScope() {
        Assert.assertEquals((Object)"application", (Object)this.metrics.getScope());
        Assert.assertEquals((Object)"base", (Object)this.baseMetrics.getScope());
        Assert.assertEquals((Object)"vendor", (Object)this.vendorMetrics.getScope());
        Assert.assertEquals((Object)CUSTOM_SCOPE, (Object)this.customScope.getScope());
    }

    @Test
    @InSequence(value=6)
    public void testMetricRegistryScopeDeprecatedRegistryType() {
        Assert.assertEquals((Object)"application", (Object)this.applicationMetrics_RegistryType.getScope());
        Assert.assertEquals((Object)"base", (Object)this.baseMetrics_RegistryType.getScope());
        Assert.assertEquals((Object)"vendor", (Object)this.vendorMetrics_RegistryType.getScope());
    }

    @Test
    @InSequence(value=7)
    public void testMetricRegistryEquivalence() {
        Assert.assertEquals((Object)this.metrics, (Object)this.applicationMetrics_RegistryType);
        Assert.assertEquals((Object)this.baseMetrics, (Object)this.baseMetrics_RegistryType);
        Assert.assertEquals((Object)this.vendorMetrics, (Object)this.vendorMetrics_RegistryType);
    }

    private void assertExists(Class<? extends Metric> expected, MetricID metricID) {
        Assert.assertNotNull((String)("Metric expected to exist but was undefined: " + metricID), (Object)this.metrics.getMetric(metricID, expected));
    }
}

