/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.tck.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramTest {
    @Inject
    private Histogram histogramInt;
    @Inject
    private MetricRegistry metrics;
    private static Histogram histogramLong = null;
    private static boolean isInitialized = false;
    static final int[] SAMPLE_INT_DATA = new int[]{0, 1, 2, 2, 2, 3, 3, 3, 3, 3, 4, 5, 5, 6, 7, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 17, 18, 18, 20, 20, 20, 21, 22, 22, 22, 24, 24, 25, 25, 27, 27, 27, 27, 27, 27, 27, 28, 28, 29, 30, 31, 31, 32, 32, 33, 33, 36, 36, 36, 36, 37, 38, 38, 38, 39, 40, 40, 41, 42, 42, 42, 43, 44, 44, 44, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47, 47, 47, 48, 48, 49, 49, 50, 51, 52, 52, 52, 53, 54, 54, 55, 56, 56, 57, 57, 59, 59, 60, 61, 61, 62, 62, 63, 64, 64, 64, 65, 66, 66, 66, 67, 67, 68, 68, 70, 71, 71, 71, 71, 72, 72, 72, 72, 73, 73, 74, 74, 74, 75, 75, 76, 76, 76, 77, 78, 78, 78, 80, 80, 81, 82, 82, 82, 83, 83, 84, 84, 85, 87, 87, 88, 88, 88, 89, 89, 89, 89, 90, 91, 92, 92, 92, 93, 94, 95, 95, 95, 96, 96, 96, 96, 97, 97, 97, 97, 98, 98, 98, 99, 99};
    static final long[] SAMPLE_LONG_DATA = new long[]{0L, 10L, 20L, 20L, 20L, 30L, 30L, 30L, 30L, 30L, 40L, 50L, 50L, 60L, 70L, 70L, 70L, 80L, 90L, 90L, 100L, 110L, 110L, 120L, 120L, 120L, 120L, 130L, 130L, 130L, 130L, 140L, 140L, 150L, 150L, 170L, 180L, 180L, 200L, 200L, 200L, 210L, 220L, 220L, 220L, 240L, 240L, 250L, 250L, 270L, 270L, 270L, 270L, 270L, 270L, 270L, 280L, 280L, 290L, 300L, 310L, 310L, 320L, 320L, 330L, 330L, 360L, 360L, 360L, 360L, 370L, 380L, 380L, 380L, 390L, 400L, 400L, 410L, 420L, 420L, 420L, 430L, 440L, 440L, 440L, 450L, 450L, 450L, 460L, 460L, 460L, 460L, 470L, 470L, 470L, 470L, 470L, 470L, 480L, 480L, 490L, 490L, 500L, 510L, 520L, 520L, 520L, 530L, 540L, 540L, 550L, 560L, 560L, 570L, 570L, 590L, 590L, 600L, 610L, 610L, 620L, 620L, 630L, 640L, 640L, 640L, 650L, 660L, 660L, 660L, 670L, 670L, 680L, 680L, 700L, 710L, 710L, 710L, 710L, 720L, 720L, 720L, 720L, 730L, 730L, 740L, 740L, 740L, 750L, 750L, 760L, 760L, 760L, 770L, 780L, 780L, 780L, 800L, 800L, 810L, 820L, 820L, 820L, 830L, 830L, 840L, 840L, 850L, 870L, 870L, 880L, 880L, 880L, 890L, 890L, 890L, 890L, 900L, 910L, 920L, 920L, 920L, 930L, 940L, 950L, 950L, 950L, 960L, 960L, 960L, 960L, 970L, 970L, 970L, 970L, 980L, 980L, 980L, 990L, 990L};

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TestUtils.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void initData() {
        if (isInitialized) {
            return;
        }
        histogramLong = this.metrics.histogram("test.longData.histogram");
        for (int i : SAMPLE_INT_DATA) {
            this.histogramInt.update(i);
        }
        for (long i : SAMPLE_LONG_DATA) {
            histogramLong.update(i);
        }
        isInitialized = true;
    }

    @Test
    public void testMetricRegistry() throws Exception {
        String histogramIntName = "org.eclipse.microprofile.metrics.tck.metrics.HistogramTest.histogramInt";
        String histogramLongName = "test.longData.histogram";
        MetricID histogramIntNameMetricID = new MetricID(histogramIntName);
        MetricID histogramLongNameMetricID = new MetricID(histogramLongName);
        Histogram histogramInt = this.metrics.getHistogram(histogramIntNameMetricID);
        Histogram histogramLong = this.metrics.getHistogram(histogramLongNameMetricID);
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)histogramInt, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)histogramLong, (Matcher)Matchers.notNullValue());
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(histogramInt, 0.5);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.5);
        TestUtils.assertEqualsWithTolerance(48.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(480.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testCount() throws Exception {
        Assert.assertEquals((long)200L, (long)this.histogramInt.getCount());
        Assert.assertEquals((long)200L, (long)histogramLong.getCount());
    }

    @Test
    public void testSum() throws Exception {
        Assert.assertEquals((long)10127L, (long)this.histogramInt.getSum());
        Assert.assertEquals((long)101270L, (long)histogramLong.getSum());
    }

    @Test
    public void testSnapshotPercentileValuesPresent() throws Exception {
        Snapshot.PercentileValue[] percentileValuesHistInt = this.histogramInt.getSnapshot().percentileValues();
        Assert.assertTrue((percentileValuesHistInt.length == 6 ? 1 : 0) != 0);
        int countDown = 6;
        for (Snapshot.PercentileValue pv : percentileValuesHistInt) {
            double percentile = pv.getPercentile();
            if (percentile != 0.5 && percentile != 0.75 && percentile != 0.95 && percentile != 0.98 && percentile != 0.99 && percentile != 0.999) continue;
            --countDown;
        }
        Assert.assertTrue((countDown == 0 ? 1 : 0) != 0);
        Snapshot.PercentileValue[] percentileValuesHisLong = histogramLong.getSnapshot().percentileValues();
        Assert.assertTrue((percentileValuesHisLong.length == 6 ? 1 : 0) != 0);
        countDown = 6;
        for (Snapshot.PercentileValue pv : percentileValuesHisLong) {
            double percentile = pv.getPercentile();
            if (percentile != 0.5 && percentile != 0.75 && percentile != 0.95 && percentile != 0.98 && percentile != 0.99 && percentile != 0.999) continue;
            --countDown;
        }
        Assert.assertTrue((countDown == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSnapshot50thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.5);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.5);
        TestUtils.assertEqualsWithTolerance(48.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(480.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshot75thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.75);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.75);
        TestUtils.assertEqualsWithTolerance(75.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(750.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshot95thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.95);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.95);
        TestUtils.assertEqualsWithTolerance(96.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(960.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshot98thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.98);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.98);
        TestUtils.assertEqualsWithTolerance(98.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(980.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshot99thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.99);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.99);
        TestUtils.assertEqualsWithTolerance(98.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(980.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshot999thPercentile() throws Exception {
        Snapshot.PercentileValue histogramIntPercentileValue = HistogramTest.getPercentileValueAt(this.histogramInt, 0.999);
        Snapshot.PercentileValue histogramLongPercentileValue = HistogramTest.getPercentileValueAt(histogramLong, 0.999);
        TestUtils.assertEqualsWithTolerance(99.0, histogramIntPercentileValue.getValue());
        TestUtils.assertEqualsWithTolerance(990.0, histogramLongPercentileValue.getValue());
    }

    @Test
    public void testSnapshotMax() throws Exception {
        Assert.assertEquals((double)99.0, (double)this.histogramInt.getSnapshot().getMax(), (double)0.0);
        Assert.assertEquals((double)990.0, (double)histogramLong.getSnapshot().getMax(), (double)0.0);
    }

    @Test
    public void testSnapshotMean() throws Exception {
        TestUtils.assertEqualsWithTolerance(50.6, this.histogramInt.getSnapshot().getMean());
        TestUtils.assertEqualsWithTolerance(506.3, histogramLong.getSnapshot().getMean());
    }

    @Test
    public void testSnapshotSize() throws Exception {
        Assert.assertEquals((long)200L, (long)this.histogramInt.getSnapshot().size());
        Assert.assertEquals((long)200L, (long)histogramLong.getSnapshot().size());
    }

    private static Snapshot.PercentileValue getPercentileValueAt(Histogram histo, double percentile) {
        Snapshot snapshot = histo.getSnapshot();
        Snapshot.PercentileValue percentileValue = null;
        for (Snapshot.PercentileValue pv : snapshot.percentileValues()) {
            if (pv.getPercentile() != percentile) continue;
            percentileValue = pv;
            break;
        }
        Assert.assertNotNull(percentileValue);
        return percentileValue;
    }
}

