/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.application;

import io.opentracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestTracer;

@Path(value="tracer")
@Traced(value=false)
public class TracerWebService {
    public static final String REST_TRACER_SERVICE_PATH = "tracer";
    public static final String REST_GET_TRACER = "getTracer";
    public static final String REST_CLEAR_TRACER = "clearTracer";
    @Inject
    private Tracer tracer;

    @GET
    @Path(value="getTracer")
    @Produces(value={"application/json"})
    public Tracer getTracer() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        TestTracer testTracer = new TestTracer();
        ArrayList<TestSpan> spans = new ArrayList<TestSpan>();
        try {
            Iterable finishedSpans = (Iterable)this.tracer.getClass().getMethod("finishedSpans", new Class[0]).invoke((Object)this.tracer, new Object[0]);
            for (Object finishedSpan : finishedSpans) {
                TestSpan testSpan = new TestSpan();
                testSpan.setStartMicros((Long)finishedSpan.getClass().getMethod("startMicros", new Class[0]).invoke(finishedSpan, new Object[0]));
                testSpan.setFinishMicros((Long)finishedSpan.getClass().getMethod("finishMicros", new Class[0]).invoke(finishedSpan, new Object[0]));
                testSpan.setCachedOperationName((String)finishedSpan.getClass().getMethod("operationName", new Class[0]).invoke(finishedSpan, new Object[0]));
                testSpan.setParentId((Long)finishedSpan.getClass().getMethod("parentId", new Class[0]).invoke(finishedSpan, new Object[0]));
                Object context = finishedSpan.getClass().getMethod("context", new Class[0]).invoke(finishedSpan, new Object[0]);
                testSpan.setSpanId((Long)context.getClass().getMethod("spanId", new Class[0]).invoke(context, new Object[0]));
                testSpan.setTraceId((Long)context.getClass().getMethod("traceId", new Class[0]).invoke(context, new Object[0]));
                testSpan.setTags((Map)finishedSpan.getClass().getMethod("tags", new Class[0]).invoke(finishedSpan, new Object[0]));
                List logEntries = (List)finishedSpan.getClass().getMethod("logEntries", new Class[0]).invoke(finishedSpan, new Object[0]);
                for (Object logEntry : logEntries) {
                    testSpan.getLogEntries().add((Map)logEntry.getClass().getMethod("fields", new Class[0]).invoke(logEntry, new Object[0]));
                }
                spans.add(testSpan);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("The injected Tracer is required to be an instance of io.opentracing.mock.MockTracer but is instead an instance of " + this.tracer, nsme);
        }
        testTracer.setSpans(spans);
        return testTracer;
    }

    @DELETE
    @Path(value="clearTracer")
    public void clearTracer() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.tracer.getClass().getMethod("reset", new Class[0]).invoke((Object)this.tracer, new Object[0]);
    }
}

