/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Message<T> {
    public static <T> Message<T> of(T payload) {
        return () -> payload;
    }

    public static <T> Message<T> of(final T payload, final Supplier<CompletionStage<Void>> ack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public CompletionStage<Void> ack() {
                return (CompletionStage)ack.get();
            }
        };
    }

    public static <T> Message<T> of(final T payload, final Supplier<CompletionStage<Void>> ack, final Function<Throwable, CompletionStage<Void>> nack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }

            @Override
            public Function<Throwable, CompletionStage<Void>> getNack() {
                return nack;
            }
        };
    }

    default public <P> Message<P> withPayload(P payload) {
        return Message.of(payload, this.getAck(), this.getNack());
    }

    default public Message<T> withAck(Supplier<CompletionStage<Void>> ack) {
        return Message.of(this.getPayload(), ack, this.getNack());
    }

    default public Message<T> withNack(Function<Throwable, CompletionStage<Void>> nack) {
        return Message.of(this.getPayload(), this.getAck(), nack);
    }

    public T getPayload();

    default public CompletionStage<Void> ack() {
        return CompletableFuture.completedFuture(null);
    }

    default public Supplier<CompletionStage<Void>> getAck() {
        return () -> CompletableFuture.completedFuture(null);
    }

    default public Function<Throwable, CompletionStage<Void>> getNack() {
        return reason -> CompletableFuture.completedFuture(null);
    }

    default public CompletionStage<Void> nack(Throwable reason) {
        if (reason == null) {
            throw new IllegalArgumentException("The reason must not be `null`");
        }
        Function<Throwable, CompletionStage<Void>> nack = this.getNack();
        if (nack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return nack.apply(reason);
    }

    default public <C> C unwrap(Class<C> unwrapType) {
        if (unwrapType == null) {
            throw new IllegalArgumentException("The target class must not be `null`");
        }
        try {
            return unwrapType.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot unwrap an instance of " + this.getClass().getName() + " to " + unwrapType.getName(), e);
        }
    }
}

