/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@ApplicationScoped
public class BeanUsingDropOverflowStrategy {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Inject
    @Channel(value="hello")
    @OnOverflow(value=OnOverflow.Strategy.DROP)
    private Emitter<String> emitter;
    private List<String> output = new CopyOnWriteArrayList<String>();
    private volatile Throwable downstreamFailure;
    private volatile boolean done;
    private Exception callerException;

    @PreDestroy
    public void terminate() {
        this.executor.shutdown();
    }

    public boolean isDone() {
        return this.done;
    }

    public List<String> output() {
        return this.output;
    }

    public Throwable failure() {
        return this.downstreamFailure;
    }

    public Exception exception() {
        return this.callerException;
    }

    public void emitThree() {
        try {
            this.emitter.send((Object)"1");
            this.emitter.send((Object)"2");
            this.emitter.send((Object)"3");
            this.emitter.complete();
        }
        catch (Exception e) {
            this.callerException = e;
        }
    }

    public void emitALotOfItems() {
        new Thread(() -> {
            try {
                for (int i = 1; i < 1000; ++i) {
                    this.emitter.send((Object)("" + i));
                }
            }
            catch (Exception e) {
                this.callerException = e;
            }
            finally {
                this.done = true;
            }
        }).start();
    }

    @Incoming(value="hello")
    @Outgoing(value="out")
    public PublisherBuilder<String> consume(PublisherBuilder<String> values) {
        return values.via(ReactiveStreams.builder().flatMapCompletionStage(s -> CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            return s;
        }, this.executor))).onError(err -> {
            this.downstreamFailure = err;
        });
    }

    @Incoming(value="out")
    public void out(String s) {
        this.output.add(s);
    }
}

