/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.channel.overflow.BeanUsingThrowExceptionStrategy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class ThrowExceptionOverflowStrategyOverflowTest
extends TckBase {
    @Inject
    private BeanUsingThrowExceptionStrategy bean;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        return ThrowExceptionOverflowStrategyOverflowTest.getBaseArchive().addClasses(new Class[]{BeanUsingThrowExceptionStrategy.class});
    }

    @Test
    public void testOverflow() throws InterruptedException {
        this.bean.tryEmitTen();
        Assertions.assertThat((int)(this.bean.accepted().size() + this.bean.rejected().size())).isEqualTo(10);
        Assertions.assertThat(this.bean.accepted()).contains((Object[])new String[]{"1"});
        Assertions.assertThat(this.bean.rejected()).isNotEmpty();
        Awaitility.await().until(() -> this.bean.output().size() == this.bean.accepted().size());
        Assertions.assertThat(this.bean.output()).containsExactlyElementsOf(this.bean.accepted());
        Assertions.assertThat((Throwable)this.bean.failure()).isNull();
        int acceptedFirstRun = this.bean.accepted().size();
        int rejectedFirstRun = this.bean.rejected().size();
        this.bean.tryEmitTen();
        Awaitility.await().until(() -> this.bean.accepted().size() + this.bean.rejected().size() == 20);
        Assertions.assertThat(this.bean.accepted()).hasSizeGreaterThan(acceptedFirstRun);
        Assertions.assertThat(this.bean.rejected()).hasSizeGreaterThan(rejectedFirstRun);
        Awaitility.await().until(() -> this.bean.output().size() == this.bean.accepted().size());
        Assertions.assertThat(this.bean.output()).containsExactlyElementsOf(this.bean.accepted());
        Assertions.assertThat((Throwable)this.bean.failure()).isNull();
    }
}

