/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.invalid;

import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.ServiceLoader;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanConsumingManyTwice;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanProducingManyTwice;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanWithBadOutgoingSignature;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanWithEmptyIncoming;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanWithEmptyOutgoing;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.BeanWithIncompleteChain;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ChannelMissingUpstream;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ChannelMultipleUpstreams;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.EmitterMissingDownstream;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.EmitterMultipleDownstreams;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ProcessorMissingDownstream;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ProcessorMissingUpstream;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ProcessorMultipleDownstreams;
import org.eclipse.microprofile.reactive.messaging.tck.invalid.ProcessorMultipleUpstreams;
import org.eclipse.microprofile.reactive.messaging.tck.metrics.ConfigAsset;
import org.eclipse.microprofile.reactive.messaging.tck.metrics.TestConnector;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InvalidConfigurationTest {
    @ArquillianResource
    private Deployer deployer;

    @Deployment(managed=false, name="empty-incoming")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> emptyIncoming() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{BeanWithEmptyIncoming.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="empty-outgoing")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> emptyOutgoing() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{BeanWithEmptyOutgoing.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="invalid-publisher-method")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> invalidPublisherMethod() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{BeanWithBadOutgoingSignature.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="incomplete-chain")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> incompleteChain() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{BeanWithIncompleteChain.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="processor-missing-upstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> processorMissingUpstream() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ProcessorMissingUpstream.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="processor-missing-downstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> processorMissingDownstream() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ProcessorMissingDownstream.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="processor-multiple-upstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> processorMultipleUpstreams() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ProcessorMultipleUpstreams.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="processor-multiple-downstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> processorMultipleDownstreams() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ProcessorMultipleDownstreams.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="emitter-missing-downstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> emitterMissingDownstream() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EmitterMissingDownstream.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="emitter-multiple-downstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> emitterMultipleDownstreams() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EmitterMultipleDownstreams.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="channel-missing-upstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> channelMissingUpstream() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ChannelMissingUpstream.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="channel-multiple-upstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> channelMultipleUpstreams() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ChannelMultipleUpstreams.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="connector-missing-upstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> connectorMissingUpstream() {
        ConfigAsset config = new ConfigAsset().put("mp.messaging.outgoing.missing.connector", "test-connector");
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestConnector.class, ArchiveExtender.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="connector-missing-downstream")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> connectorMissingDownstream() {
        ConfigAsset config = new ConfigAsset().put("mp.messaging.incoming.missing.connector", "test-connector");
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestConnector.class, ArchiveExtender.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="connector-multiple-downstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> connectorMultipleDownstreams() {
        ConfigAsset config = new ConfigAsset().put("mp.messaging.incoming.many.connector", "test-connector");
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestConnector.class, BeanConsumingManyTwice.class, ArchiveExtender.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Deployment(managed=false, name="connector-multiple-upstreams")
    @ShouldThrowException(value=DeploymentException.class, testable=true)
    public static Archive<JavaArchive> connectorMultipleUpstreams() {
        ConfigAsset config = new ConfigAsset().put("mp.messaging.outgoing.many.connector", "test-connector");
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestConnector.class, BeanProducingManyTwice.class, ArchiveExtender.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void checkThatEmptyIncomingAreRejected() {
        this.deployer.deploy("empty-incoming");
    }

    @Test
    public void checkThatEmptyOutgoingAreRejected() {
        this.deployer.deploy("empty-outgoing");
    }

    @Test
    public void checkThatInvalidOutgoingSignaturesAreRejected() {
        this.deployer.deploy("invalid-publisher-method");
    }

    @Test
    public void checkThatIncompleteChainsAreDetected() {
        this.deployer.deploy("incomplete-chain");
    }

    @Test
    public void checkThatProcessorsWithoutUpstreamAreDetected() {
        this.deployer.deploy("processor-missing-upstream");
    }

    @Test
    public void checkThatProcessorsWithoutDownstreamAreDetected() {
        this.deployer.deploy("processor-missing-downstream");
    }

    @Test
    public void checkThatProcessorsWithTooManyUpstreamsAreDetected() {
        this.deployer.deploy("processor-multiple-upstreams");
    }

    @Test
    public void checkThatProcessorsWithTooManyDownstreamsAreDetected() {
        this.deployer.deploy("processor-multiple-downstreams");
    }

    @Test
    public void checkThatEmitterWithoutDownstreamAreDetected() {
        this.deployer.deploy("emitter-missing-downstream");
    }

    @Test
    public void checkThatEmitterWithMultipleDownstreamsAreDetected() {
        this.deployer.deploy("emitter-multiple-downstreams");
    }

    @Test
    public void checkThatChannelWithoutUpstreamAreDetected() {
        this.deployer.deploy("channel-missing-upstream");
    }

    @Test
    public void checkThatChannelWithMultipleUpstreamsAreDetected() {
        this.deployer.deploy("channel-multiple-upstreams");
    }

    @Test
    public void checkThatIncomingConnectorWithoutDownstreamAreDetected() {
        this.deployer.deploy("connector-missing-downstream");
    }

    @Test
    public void checkThatIncomingConnectorWithMultipleDownstreamAreDetected() {
        this.deployer.deploy("connector-multiple-downstreams");
    }

    @Test
    public void checkThatOutgoingConnectorWithoutUpstreamAreDetected() {
        this.deployer.deploy("connector-missing-upstream");
    }

    @Test
    public void checkThatOutgoingConnectorWithMultipleUpstreamsAreDetected() {
        this.deployer.deploy("connector-multiple-upstreams");
    }
}

