/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.invalid;

import jakarta.enterprise.inject.spi.DefinitionException;
import java.util.ServiceLoader;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.signatures.invalid.IncomingReturningNonVoid;
import org.eclipse.microprofile.reactive.messaging.tck.signatures.invalid.IncomingReturningNonVoidCompletionStage;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InvalidSubscriberSignatureTest {
    @ArquillianResource
    private Deployer deployer;

    @Deployment(managed=false, name="incoming-returning-object")
    @ShouldThrowException(value=DefinitionException.class, testable=true)
    public static Archive<JavaArchive> incomingReturningNonVoid() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{IncomingReturningNonVoid.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void checkThatIncomingShouldNotReturnObject() {
        this.deployer.deploy("incoming-returning-object");
    }

    @Deployment(managed=false, name="incoming-returning-non-void-cs")
    @ShouldThrowException(value=DefinitionException.class, testable=true)
    public static Archive<JavaArchive> incomingReturningNonVoidCompletionStage() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{IncomingReturningNonVoidCompletionStage.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void checkThatIncomingShouldNotReturnNonVoidCompletionStage() {
        this.deployer.deploy("incoming-returning-non-void-cs");
    }
}

