/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.LongStream;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcatStageVerification
extends AbstractStageVerification {
    ConcatStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void concatStageShouldConcatTwoGraphs() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.rs.of((Object[])new Integer[]{4, 5, 6})).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4, 5, 6));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void concatStageShouldCancelSecondStageIfFirstFails() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage completion = this.rs.concat(this.rs.failed((Throwable)new QuietRuntimeException("failed")), this.infiniteStream().onTerminate(() -> cancelled.complete(null))).ignore().run(this.getEngine());
        this.await(cancelled);
        this.await(completion);
    }

    @Test
    public void concatStageShouldCancelSecondStageIfFirstCancellationOccursDuringFirst() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.rs.concat(this.infiniteStream(), this.infiniteStream().onTerminate(() -> cancelled.complete(null))).limit(5L).toList().run(this.getEngine());
        this.await(cancelled);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Arrays.asList(1, 2, 3, 4, 5));
    }

    @Test
    public void concatStageShouldCancelSecondStageIfCancellationOccursDuringSecond() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.infiniteStream().onTerminate(() -> cancelled.complete(null))).limit(5L).toList().run(this.getEngine());
        this.await(cancelled);
        Assert.assertEquals((Collection)((Collection)this.await(result)), Arrays.asList(1, 2, 3, 1, 2));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void concatStageShouldPropagateExceptionsFromSecondStage() {
        this.await(this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.rs.failed((Throwable)new QuietRuntimeException("failed"))).toList().run(this.getEngine()));
    }

    @Test
    public void concatStageShouldWorkWithEmptyFirstGraph() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.concat(this.rs.empty(), this.rs.of((Object[])new Integer[]{1, 2, 3})).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void concatStageShouldWorkWithEmptySecondGraph() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.rs.empty()).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void concatStageShouldWorkWithBothGraphsEmpty() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.concat(this.rs.empty(), this.rs.empty()).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void concatStageShouldSupportNestedConcats() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.concat(this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.rs.of((Object[])new Integer[]{4, 5, 6})), this.rs.concat(this.rs.of((Object[])new Integer[]{7, 8, 9}), this.rs.of((Object[])new Integer[]{10, 11, 12}))).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
    }

    @Test
    public void concatStageBuilderShouldBeReusable() {
        PublisherBuilder concated = this.rs.concat(this.rs.of((Object[])new Integer[]{1, 2, 3}), this.rs.of((Object[])new Integer[]{4, 5, 6}));
        Assert.assertEquals((Collection)((Collection)this.await(concated.toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4, 5, 6));
        Assert.assertEquals((Collection)((Collection)this.await(concated.toList().run(this.getEngine()))), Arrays.asList(1, 2, 3, 4, 5, 6));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.singletonList(new PublisherVerification());
    }

    class PublisherVerification
    extends AbstractStageVerification.StagePublisherVerification<Long> {
        PublisherVerification() {
        }

        public Publisher<Long> createPublisher(long elements) {
            long toEmitFromFirst = elements / 2L;
            return ConcatStageVerification.this.rs.concat(ConcatStageVerification.this.rs.fromIterable(() -> LongStream.rangeClosed(1L, toEmitFromFirst).boxed().iterator()), ConcatStageVerification.this.rs.fromIterable(() -> LongStream.rangeClosed(toEmitFromFirst + 1L, elements).boxed().iterator())).buildRs(ConcatStageVerification.this.getEngine());
        }
    }
}

