/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OnStagesVerification
extends AbstractStageVerification {
    private Runnable noop = () -> {};

    OnStagesVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void onCompleteStageShouldBeCalledWhenTheStreamComplete() {
        AtomicBoolean called = new AtomicBoolean();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).onComplete(() -> called.set(true)).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void onTerminateStageShouldBeCalledWhenTheStreamComplete() {
        AtomicBoolean called = new AtomicBoolean();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).onTerminate(() -> called.set(true)).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void onErrorStageShouldNotBeCalledWhenTheStreamComplete() {
        AtomicBoolean called = new AtomicBoolean();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).onError(failure -> called.set(true)).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertFalse((boolean)called.get());
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void onCompleteStageShouldPropagateRuntimeExceptions() {
        this.await(this.rs.of((Object)"foo").onComplete(() -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine()));
    }

    @Test
    public void onCompleteStageShouldNotBeCalledWhenTheStreamFailed() {
        AtomicBoolean called = new AtomicBoolean();
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onComplete(() -> called.set(true)).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertFalse((boolean)called.get());
    }

    @Test
    public void onErrorStageShouldBeCalledWhenTheStreamFailed() {
        AtomicReference called = new AtomicReference();
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onError(called::set).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertNotNull(called.get());
        Assert.assertTrue((boolean)((Throwable)called.get()).getMessage().equalsIgnoreCase("failed"));
    }

    @Test
    public void onErrorStageShouldBeCalledWhenTheStreamFailedBecauseOfAnIntermediateStage() {
        AtomicReference called = new AtomicReference();
        this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).map(x -> {
            throw new QuietRuntimeException("failed");
        }).onError(called::set).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertNotNull(called.get());
        Assert.assertTrue((boolean)((Throwable)called.get()).getMessage().equalsIgnoreCase("failed"));
    }

    @Test
    public void onTerminateStageShouldBeCalledWhenTheStreamFailed() {
        AtomicBoolean called = new AtomicBoolean();
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onTerminate(() -> called.set(true)).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void onTerminateStageShouldBeCalledWhenTheStreamFailedBecauseOfAnIntermediateStage() {
        AtomicBoolean called = new AtomicBoolean();
        this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).map(x -> {
            throw new QuietRuntimeException("failed");
        }).onTerminate(() -> called.set(true)).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertTrue((boolean)called.get());
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void onTerminateStageShouldPropagateRuntimeExceptions() {
        this.await(this.rs.of((Object)"foo").onTerminate(() -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine()));
    }

    @Test
    public void onCompleteAndOnTerminateStagesShouldBeCalledWhenTheStreamCompletes() {
        AtomicBoolean onTerminateCalled = new AtomicBoolean();
        AtomicBoolean onCompleteCalled = new AtomicBoolean();
        this.await(this.rs.empty().onComplete(() -> onCompleteCalled.set(true)).onTerminate(() -> onTerminateCalled.set(true)).toList().run(this.getEngine()));
        Assert.assertTrue((boolean)onTerminateCalled.get());
        Assert.assertTrue((boolean)onCompleteCalled.get());
    }

    @Test
    public void onErrorAndOnTerminateStagesShouldBeCalledWhenTheStreamFails() {
        AtomicBoolean onTerminateCalled = new AtomicBoolean();
        AtomicReference onErrorCalled = new AtomicReference();
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onError(onErrorCalled::set).onTerminate(() -> onTerminateCalled.set(true)).toList().run(this.getEngine()).exceptionally(t -> Collections.emptyList()));
        Assert.assertTrue((boolean)onTerminateCalled.get());
        Assert.assertEquals((String)((Throwable)onErrorCalled.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onTerminateShouldBeCalledWhenTheStreamIsCancelledFromDownstream() {
        CompletableFuture onTerminateCalled = new CompletableFuture();
        this.rs.of((Object)1).flatMapCompletionStage(i -> new CompletableFuture()).onTerminate(() -> onTerminateCalled.complete(null)).cancel().run(this.getEngine());
        this.await(onTerminateCalled);
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Arrays.asList(new Object[]{new OnCompleteVerification(), new OnTerminateVerification(), new OnErrorVerification()});
    }

    public class OnCompleteVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return OnStagesVerification.this.rs.builder().onComplete(OnStagesVerification.this.noop).buildRs(OnStagesVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return OnStagesVerification.this.rs.failed((Throwable)new QuietRuntimeException("failed")).onComplete(OnStagesVerification.this.noop).buildRs(OnStagesVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }

    public class OnTerminateVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return OnStagesVerification.this.rs.builder().onTerminate(OnStagesVerification.this.noop).buildRs(OnStagesVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return OnStagesVerification.this.rs.failed((Throwable)new QuietRuntimeException("failed")).onTerminate(OnStagesVerification.this.noop).buildRs(OnStagesVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }

    public class OnErrorVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return OnStagesVerification.this.rs.builder().onError(x -> {}).buildRs(OnStagesVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return OnStagesVerification.this.rs.failed((Throwable)new QuietRuntimeException("failed")).onError(x -> {}).buildRs(OnStagesVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

