/*
 * Copyright 2017 Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.eclipse.microprofile.rest.client.tck.providers;

import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;

public class SimpleFeature implements Feature{
    private static boolean invoked = false;

    @Override
    public boolean configure(FeatureContext featureContext) {
        invoked = true;
        return true;
    }

    public static boolean wasInvoked() {
        return invoked;
    }

    public static void reset() {
        invoked = false;
    }
}
