/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import javax.inject.Inject;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientWithURIAndInterceptor;
import org.eclipse.microprofile.rest.client.tck.interfaces.Loggable;
import org.eclipse.microprofile.rest.client.tck.interfaces.LoggableInterceptor;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIInterceptorTest
extends Arquillian {
    @Inject
    @RestClient
    private ClientWithURIAndInterceptor client;

    @Deployment
    public static WebArchive createDeployment() {
        String simpleName = CDIInterceptorTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{ClientWithURIAndInterceptor.class, Loggable.class, LoggableInterceptor.class, ReturnWithURLRequestFilter.class})).addAsManifestResource((Asset)new StringAsset("<beans xmlns=\"http://java.sun.com/xml/ns/javaee\"       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"       xsi:schemaLocation=\"          http://java.sun.com/xml/ns/javaee          http://java.sun.com/xml/ns/javaee/beans_1_0.xsd\">       <interceptors>           <class>org.eclipse.microprofile.rest.client.tck.interfaces.LoggableInterceptor</class>       </interceptors></beans>"), "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testInterceptorInvoked() throws Exception {
        LoggableInterceptor.setInvocationMessage("");
        String expectedResponse = "GET http://localhost:5017/myBaseUri/hello";
        Assert.assertEquals((String)this.client.get(), (String)expectedResponse);
        Assert.assertEquals((String)LoggableInterceptor.getInvocationMessage(), (String)(ClientWithURIAndInterceptor.class.getName() + ".get " + expectedResponse));
    }

    @Test
    public void testInterceptorNotInvokedWhenNoAnnotationApplied() throws Exception {
        LoggableInterceptor.setInvocationMessage("");
        String expectedResponse = "GET http://localhost:5017/myBaseUri/hello";
        Assert.assertEquals((String)this.client.getNoInterceptor(), (String)expectedResponse);
        Assert.assertEquals((String)LoggableInterceptor.getInvocationMessage(), (String)"");
    }
}

