/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ConfigKeyClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HasSessionScopeTest
extends Arquillian {
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static WebArchive createDeployment() {
        String url = SimpleGetApi.class.getName() + "/mp-rest/url=http://localhost:8080";
        String scope = SimpleGetApi.class.getName() + "/mp-rest/scope=" + SessionScoped.class.getName();
        String configKeyScope = "myConfigKey/mp-rest/scope=" + SessionScoped.class.getName();
        String simpleName = HasSessionScopeTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApi.class, MySessionScopedApi.class, ConfigKeyClient.class})).addAsManifestResource((Asset)new StringAsset(url + "\n" + scope + "\n" + configKeyScope), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testHasSingletonScoped() {
        Set beans = this.beanManager.getBeans(SimpleGetApi.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), SessionScoped.class);
    }

    @Test
    public void testHasSessionScopedFromConfigKey() {
        Set beans = this.beanManager.getBeans(ConfigKeyClient.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), SessionScoped.class);
    }

    @Test
    public void testHasSessionScopedWhenAnnotated() {
        Set beans = this.beanManager.getBeans(MySessionScopedApi.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), SessionScoped.class);
    }

    @SessionScoped
    @Path(value="/")
    @RegisterRestClient
    public static interface MySessionScopedApi {
        @GET
        public Response get();
    }
}

