/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.testng.Assert;

@Path(value="MpRestClientAsyncTestEndpoint")
public class MpRestClientAsyncTestEndpoint {
    public static final String TEST_PASSED = "Test Passed";
    public static final String TEST_VALUE = "TEST_VALUE";
    @Inject
    private InMemorySpanExporter spanExporter;

    @GET
    @Path(value="/mpclient")
    public Response requestMpClient(@Context UriInfo uriInfo) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", "bar").build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)"bar", (String)baggage.getEntryValue("foo"));
            String baseUrl = uriInfo.getAbsolutePath().toString().replace("/mpclient", "");
            URI baseUri = null;
            try {
                baseUri = new URI(baseUrl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertNotNull((Object)Span.current());
            MpClientTwo mpClientTwo = (MpClientTwo)RestClientBuilder.newBuilder().baseUri(baseUri).build(MpClientTwo.class);
            String result = mpClientTwo.requestMpClient(TEST_VALUE);
            Assert.assertEquals((String)TEST_PASSED, (String)result);
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    @GET
    @Path(value="/mpclientasync")
    public Response requestMpClientAsync(@Context UriInfo uriInfo) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", "bar").build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)"bar", (String)baggage.getEntryValue("foo"));
            String baseUrl = uriInfo.getAbsolutePath().toString().replace("/mpclientasync", "");
            URI baseUri = null;
            try {
                baseUri = new URI(baseUrl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertNotNull((Object)Span.current());
            MpClientTwoAsync mpClientTwo = (MpClientTwoAsync)RestClientBuilder.newBuilder().baseUri(baseUri).build(MpClientTwoAsync.class);
            String result = mpClientTwo.requestMpClient(TEST_VALUE).toCompletableFuture().join();
            Assert.assertEquals((String)TEST_PASSED, (String)result);
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    @GET
    @Path(value="/mpclientasyncerror")
    public Response requestMpClientAsyncError(@Context UriInfo uriInfo) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", "bar").build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)"bar", (String)baggage.getEntryValue("foo"));
            String baseUrl = uriInfo.getAbsolutePath().toString().replace("/mpclientasyncerror", "");
            URI baseUri = null;
            try {
                baseUri = new URI(baseUrl);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            Assert.assertNotNull((Object)Span.current());
            MpClientTwoAsyncError mpClientTwoError = (MpClientTwoAsyncError)RestClientBuilder.newBuilder().baseUri(baseUri).build(MpClientTwoAsyncError.class);
            String result = mpClientTwoError.requestMpClientError(TEST_VALUE).exceptionally(e -> "Exception:" + MpRestClientAsyncTestEndpoint.extractResponseStatus(e)).toCompletableFuture().join();
            Assert.assertEquals((String)"Exception:400", (String)result);
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    private static int extractResponseStatus(Throwable originalException) {
        Throwable t;
        for (t = originalException; t != null && !(t instanceof WebApplicationException); t = t.getCause()) {
        }
        if (t == null) {
            throw new RuntimeException("Non WebApplicationException thrown", originalException);
        }
        WebApplicationException webEx = (WebApplicationException)t;
        return webEx.getResponse().getStatus();
    }

    @GET
    @Path(value="requestMpClient")
    public Response requestMpClient(@QueryParam(value="value") String value) {
        Assert.assertNotNull((Object)Span.current());
        Assert.assertEquals((String)TEST_VALUE, (String)value);
        Baggage baggage = Baggage.current();
        Assert.assertEquals((String)"bar", (String)baggage.getEntryValue("foo"));
        return Response.ok((Object)TEST_PASSED).build();
    }

    @GET
    @Path(value="requestMpClientError")
    public Response requestMpClientError(@QueryParam(value="value") String value) {
        Assert.assertNotNull((Object)Span.current());
        Assert.assertEquals((String)TEST_VALUE, (String)value);
        Baggage baggage = Baggage.current();
        Assert.assertEquals((String)"bar", (String)baggage.getEntryValue("foo"));
        return Response.status((int)400).build();
    }

    public static interface MpClientTwo {
        @GET
        @Path(value="requestMpClient")
        public String requestMpClient(@QueryParam(value="value") String var1);
    }

    public static interface MpClientTwoAsync {
        @GET
        @Path(value="requestMpClient")
        public CompletionStage<String> requestMpClient(@QueryParam(value="value") String var1);
    }

    public static interface MpClientTwoAsyncError {
        @GET
        @Path(value="requestMpClientError")
        public CompletionStage<String> requestMpClientError(@QueryParam(value="value") String var1);
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }
}

