/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.spi;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.eclipse.microprofile.telemetry.tracing.tck.spi.TestCustomizer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomizerSpiTest
extends Arquillian {
    @Inject
    private Tracer tracer;
    @Inject
    private InMemorySpanExporter exporter;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, TestCustomizer.class})).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{TestCustomizer.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=in-memory"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testCustomizer() {
        Span span = this.tracer.spanBuilder("span").startSpan();
        span.end();
        List<SpanData> spanItems = this.exporter.getFinishedSpanItems(1);
        Assert.assertEquals((int)spanItems.size(), (int)1);
        SpanData spanData = spanItems.get(0);
        Assert.assertEquals((String)((String)spanData.getResource().getAttribute(TestCustomizer.TEST_KEY)), (String)"test-value");
        Assert.assertTrue((boolean)TestCustomizer.LOGGED_EVENTS.contains("propagator"));
        Assert.assertTrue((boolean)TestCustomizer.LOGGED_EVENTS.contains("properties"));
        Assert.assertTrue((boolean)TestCustomizer.LOGGED_EVENTS.contains("sampler"));
        Assert.assertTrue((boolean)TestCustomizer.LOGGED_EVENTS.contains("exporter"));
        Assert.assertTrue((boolean)TestCustomizer.LOGGED_EVENTS.contains("tracer"));
    }
}

