/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.testng.Assert;

@ApplicationScoped
public class InMemoryMetricExporter
implements MetricExporter {
    private final Queue<MetricData> finishedMetricItems = new ConcurrentLinkedQueue<MetricData>();
    private final AggregationTemporality aggregationTemporality = AggregationTemporality.DELTA;
    private boolean isStopped = false;

    public List<MetricData> getFinishedMetricItems() {
        return this.finishedMetricItems.stream().collect(Collectors.toList());
    }

    public List<MetricData> getMetricData(String metricName) {
        this.assertMetricNameFound(metricName);
        return this.getFinishedMetricItems().stream().filter(metric -> metric.getName() == metricName).collect(Collectors.toList());
    }

    public void assertMetricNameFound(String metricName) {
        Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertTrue((this.getFinishedMetricItems().stream().filter(metric -> metric.getName() == metricName).collect(Collectors.toList()).size() > 0 ? 1 : 0) != 0));
    }

    public void reset() {
        this.finishedMetricItems.clear();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporality;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedMetricItems.addAll(metrics);
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedMetricItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

