/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BasicHttpClient {
    private URI baseUri;

    public BasicHttpClient(URL baseUrl) {
        try {
            this.baseUri = baseUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int get(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            URL spanUrl = this.baseUri.resolve(path).toURL();
            HttpURLConnection connection = (HttpURLConnection)spanUrl.openConnection();
            try {
                int n = connection.getResponseCode();
                return n;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception retrieving " + String.valueOf(spanUrl), e);
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception retrieving path " + path, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getResponseMessage(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            URL spanUrl = this.baseUri.resolve(path).toURL();
            HttpURLConnection connection = (HttpURLConnection)spanUrl.openConnection();
            try {
                String string;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    String inputLine;
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    string = response.toString();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception retrieving " + String.valueOf(spanUrl), e);
                    }
                }
                in.close();
                return string;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception retrieving path " + path, e);
        }
    }
}

