/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.cdi;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.context.Scope;
import jakarta.inject.Inject;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaggageBeanTest
extends Arquillian {
    @Inject
    private Baggage injectedBaggage;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.sdk.disabled", "false");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml")).addAsResource((Asset)config, "META-INF/microprofile-config.properties");
    }

    @Test
    public void baggageBeanChange() {
        String key = "testKey";
        Assert.assertNull((Object)this.injectedBaggage.getEntryValue(key));
        Baggage baggage1 = Baggage.builder().put(key, "value1").build();
        Assert.assertNull((Object)this.injectedBaggage.getEntryValue(key));
        try (Scope s = baggage1.makeCurrent();){
            Assert.assertEquals((String)this.injectedBaggage.getEntryValue(key), (String)"value1");
            Baggage baggage2 = Baggage.builder().put(key, "value2").build();
            Assert.assertEquals((String)this.injectedBaggage.getEntryValue(key), (String)"value1");
            try (Scope s2 = baggage2.makeCurrent();){
                Assert.assertEquals((String)this.injectedBaggage.getEntryValue(key), (String)"value2");
            }
            Assert.assertEquals((String)this.injectedBaggage.getEntryValue(key), (String)"value1");
        }
        Assert.assertNull((Object)this.injectedBaggage.getEntryValue(key));
    }
}

