/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.eclipse.microprofile.telemetry.tracing.tck.rest.PropagationHelper;
import org.eclipse.microprofile.telemetry.tracing.tck.rest.TestPropagator;
import org.eclipse.microprofile.telemetry.tracing.tck.rest.TestPropagatorProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PropagatorSpiTest
extends Arquillian {
    public static final String TEST_VALUE = "test-value";
    public static final String TEST_KEY = "test-key";
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter exporter;
    @Inject
    private Baggage baggage;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{TestPropagator.class, TestPropagatorProvider.class, InMemorySpanExporter.class, InMemorySpanExporterProvider.class, PropagationHelper.class, PropagationHelper.SpanResourceClient.class})).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsServiceProvider(ConfigurablePropagatorProvider.class, new Class[]{TestPropagatorProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.propagators=test-propagator\notel.traces.exporter=in-memory\notel.metrics.exporter=none"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.exporter != null) {
            this.exporter.reset();
        }
    }

    @Test
    void testSPIPropagator() {
        try (Scope s = this.baggage.toBuilder().put(TEST_KEY, TEST_VALUE).build().makeCurrent();){
            WebTarget target = ClientBuilder.newClient().target(this.url.toString()).path("baggage");
            Response response = target.request().get();
            Assert.assertEquals((int)response.getStatus(), (int)200);
        }
        this.exporter.assertSpanCount(2);
        SpanData server = this.exporter.getFirst(SpanKind.SERVER);
        Assert.assertEquals((String)TEST_VALUE, (String)((String)server.getAttributes().get(AttributeKey.stringKey((String)TEST_KEY))));
        SpanData client = this.exporter.getFirst(SpanKind.CLIENT);
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/baggage")
    public static class BaggageResource {
        @Inject
        private Baggage baggage;
        @Inject
        private Span span;

        @GET
        public Response get(@Context HttpHeaders headers) {
            try {
                Assert.assertNotNull((Object)headers.getHeaderString("TEST-SPAN"));
                Assert.assertNotNull((Object)headers.getHeaderString("TEST-BAGGAGE"));
                Assert.assertNull((Object)headers.getHeaderString("traceparent"));
                Assert.assertNull((Object)headers.getHeaderString("tracestate"));
                Assert.assertNull((Object)headers.getHeaderString("baggage"));
                this.span.setAttribute(PropagatorSpiTest.TEST_KEY, this.baggage.getEntryValue(PropagatorSpiTest.TEST_KEY));
                return Response.ok().build();
            }
            catch (Throwable e) {
                System.err.println("Baggage Resource Exception:");
                e.printStackTrace();
                throw e;
            }
        }
    }
}

