/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RestClientSpanTest
extends Arquillian {
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;
    private SpanResourceClient client;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=in-memory\notel.metrics.exporter=none"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            try {
                this.client = (SpanResourceClient)RestClientBuilder.newBuilder().baseUri(this.url.toURI()).build(SpanResourceClient.class);
            }
            catch (IllegalStateException | URISyntaxException | RestClientDefinitionException e) {
                Assert.fail((String)"Failed to create rest client", (Throwable)e);
            }
        }
    }

    @Test
    void span() {
        Response response = this.client.span();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span");
        Assert.assertEquals((String)client.getTraceId(), (String)server.getTraceId());
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    @Test
    void spanName() {
        Response response = this.client.spanName("1");
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/1");
        Assert.assertFalse((boolean)server.getName().contains("span/1"), (String)"Span name should not contain full path when using @PathParam");
        Assert.assertTrue((boolean)((String)server.getAttributes().get(HttpAttributes.HTTP_ROUTE)).contains("span/{name}"), (String)"Route should contain path template");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/1");
        Assert.assertFalse((boolean)client.getName().contains("span/1"), (String)"Span name should not contain full path when using @PathParam");
        Assert.assertEquals((String)server.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    @Test
    void spanNameQuery() {
        Response response = this.client.spanNameQuery("1", "query");
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/1?query=query");
        Assert.assertFalse((boolean)server.getName().contains("=query"), (String)"Span name should not contain query when using @QueryParam");
        Assert.assertFalse((boolean)((String)server.getAttributes().get(HttpAttributes.HTTP_ROUTE)).contains("=query"), (String)"Route should not contain query when using @QueryParam");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/1?query=query");
        Assert.assertFalse((boolean)client.getName().contains("=query"), (String)"Span name should not contain query when using @QueryParam");
        Assert.assertEquals((String)client.getTraceId(), (String)server.getTraceId());
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    @Test
    void spanError() {
        WebTarget target = ClientBuilder.newClient().target(this.url.toString() + "span/error");
        Response response = target.request().get();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/error", (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        Assert.assertEquals((Object)server.getStatus().getStatusCode(), (Object)StatusCode.ERROR);
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/error", (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        Assert.assertEquals((Object)client.getStatus().getStatusCode(), (Object)StatusCode.ERROR);
        Assert.assertEquals((String)client.getTraceId(), (String)server.getTraceId());
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    @Test
    void spanChildWithParameter() {
        Response response = this.client.spanChildWithParameter("testParameterValue");
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(3);
        SpanData internal = this.spanExporter.getFirst(SpanKind.INTERNAL);
        Assert.assertEquals((Object)internal.getKind(), (Object)SpanKind.INTERNAL);
        Assert.assertEquals((String)internal.getName(), (String)"SpanBean.spanChildWithParameter");
        Assert.assertEquals((String)((String)internal.getAttributes().get(AttributeKey.stringKey((String)"testParameter"))), (String)"testParameterValue");
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/childParameterWithParameter/testParameterValue");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/childParameterWithParameter/testParameterValue");
        Assert.assertEquals((String)internal.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getSpanId(), (String)internal.getParentSpanId());
        Assert.assertEquals((String)client.getSpanId(), (String)server.getParentSpanId());
    }

    @Test
    void spanChild() {
        Response response = this.client.spanChild();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(3);
        SpanData internal = this.spanExporter.getFirst(SpanKind.INTERNAL);
        Assert.assertEquals((Object)internal.getKind(), (Object)SpanKind.INTERNAL);
        Assert.assertEquals((String)internal.getName(), (String)"SpanBean.spanChild");
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/child");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/child");
        Assert.assertEquals((String)internal.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getSpanId(), (String)internal.getParentSpanId());
        Assert.assertEquals((String)client.getSpanId(), (String)server.getParentSpanId());
    }

    @Test
    void spanCurrent() {
        Response response = this.client.spanCurrent();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/current");
        Assert.assertEquals((String)((String)server.getAttributes().get(AttributeKey.stringKey((String)"tck.current.key"))), (String)"tck.current.value");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/current");
        Assert.assertEquals((String)server.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)client.getSpanId(), (String)server.getParentSpanId());
    }

    @Test
    void spanNew() {
        Response response = this.client.spanNew();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.OK);
        this.spanExporter.assertSpanCount(3);
        SpanData internal = this.spanExporter.getFirst(SpanKind.INTERNAL);
        Assert.assertEquals((Object)internal.getKind(), (Object)SpanKind.INTERNAL);
        Assert.assertEquals((String)internal.getName(), (String)"span.new");
        Assert.assertEquals((String)((String)internal.getAttributes().get(AttributeKey.stringKey((String)"tck.new.key"))), (String)"tck.new.value");
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/new");
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/new");
        Assert.assertEquals((String)internal.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getTraceId(), (String)client.getTraceId());
        Assert.assertEquals((String)server.getSpanId(), (String)internal.getParentSpanId());
        Assert.assertEquals((String)client.getSpanId(), (String)server.getParentSpanId());
    }

    @Test
    void spanClientError() {
        WebTarget target = ClientBuilder.newClient().target(this.url.toString() + "span/clienterror");
        Response response = target.request().get();
        this.assertResponseStatus(response, (Response.StatusType)Response.Status.BAD_REQUEST);
        this.spanExporter.assertSpanCount(2);
        SpanData server = this.spanExporter.getFirst(SpanKind.SERVER);
        this.assertServerSpan(server, "span/clienterror", (Response.StatusType)Response.Status.BAD_REQUEST);
        Assert.assertEquals((Object)server.getStatus().getStatusCode(), (Object)StatusCode.UNSET);
        SpanData client = this.spanExporter.getFirst(SpanKind.CLIENT);
        this.assertClientSpan(client, "span/clienterror", (Response.StatusType)Response.Status.BAD_REQUEST);
        Assert.assertEquals((Object)client.getStatus().getStatusCode(), (Object)StatusCode.ERROR);
        Assert.assertEquals((String)client.getTraceId(), (String)server.getTraceId());
        Assert.assertEquals((String)server.getParentSpanId(), (String)client.getSpanId());
    }

    private void assertClientSpan(SpanData client, String path) {
        this.assertClientSpan(client, path, (Response.StatusType)Response.Status.OK);
    }

    private void assertClientSpan(SpanData client, String path, Response.StatusType status) {
        Assert.assertEquals((Object)client.getKind(), (Object)SpanKind.CLIENT);
        Assert.assertEquals((int)((Long)client.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)status.getStatusCode());
        Assert.assertEquals((String)((String)client.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)client.getAttributes().get(UrlAttributes.URL_FULL)), (String)(this.url.toString() + path));
        Assert.assertEquals((String)((String)client.getAttributes().get(ServerAttributes.SERVER_ADDRESS)), (String)this.url.getHost());
        if (this.url.getPort() != this.url.getDefaultPort()) {
            Assert.assertEquals((int)((Long)client.getAttributes().get(ServerAttributes.SERVER_PORT)).intValue(), (int)this.url.getPort());
        }
    }

    private void assertServerSpan(SpanData server, String path) {
        this.assertServerSpan(server, path, (Response.StatusType)Response.Status.OK);
    }

    private void assertServerSpan(SpanData server, String path, Response.StatusType status) {
        Assert.assertEquals((Object)server.getKind(), (Object)SpanKind.SERVER);
        Assert.assertEquals((int)((Long)server.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)status.getStatusCode());
        Assert.assertEquals((String)((String)server.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)server.getAttributes().get(UrlAttributes.URL_SCHEME)), (String)this.url.getProtocol());
        if (server.getAttributes().get(UrlAttributes.URL_QUERY) != null) {
            Assert.assertEquals((String)((String)server.getAttributes().get(UrlAttributes.URL_PATH) + "?" + (String)server.getAttributes().get(UrlAttributes.URL_QUERY)), (String)(this.url.getPath() + path));
        } else {
            Assert.assertEquals((String)((String)server.getAttributes().get(UrlAttributes.URL_PATH)), (String)(this.url.getPath() + path));
        }
        Assert.assertNotNull((Object)server.getAttributes().get(HttpAttributes.HTTP_ROUTE));
        Assert.assertEquals((String)((String)server.getAttributes().get(ServerAttributes.SERVER_ADDRESS)), (String)this.url.getHost());
        if (this.url.getPort() != this.url.getDefaultPort()) {
            Assert.assertEquals((int)((Long)server.getAttributes().get(ServerAttributes.SERVER_PORT)).intValue(), (int)this.url.getPort());
        }
    }

    private void assertResponseStatus(Response response, Response.StatusType status) {
        Assert.assertEquals((int)response.getStatus(), (int)status.getStatusCode());
    }

    @RegisterRestClient(configKey="client")
    @Path(value="/")
    public static interface SpanResourceClient {
        @GET
        @Path(value="/span")
        public Response span();

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String var1);

        @GET
        @Path(value="/span/{name}")
        public Response spanNameQuery(@PathParam(value="name") String var1, @QueryParam(value="query") String var2);

        @GET
        @Path(value="/span/child")
        public Response spanChild();

        @GET
        @Path(value="/span/childParameterWithParameter/{name}")
        public Response spanChildWithParameter(@PathParam(value="name") String var1);

        @GET
        @Path(value="/span/current")
        public Response spanCurrent();

        @GET
        @Path(value="/span/new")
        public Response spanNew();
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @ApplicationScoped
    public static class SpanBean {
        @WithSpan
        void spanChild() {
        }

        @WithSpan
        void spanChildWithParameter(@SpanAttribute(value="testParameter") String testParameter) {
        }
    }

    @RequestScoped
    @Path(value="/")
    public static class SpanResource {
        @Inject
        private SpanBean spanBean;
        @Inject
        private Span span;
        @Inject
        private Tracer tracer;

        @GET
        @Path(value="/span")
        public Response span() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String name, @QueryParam(value="query") String query) {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/error")
        public Response spanError() {
            return Response.serverError().build();
        }

        @GET
        @Path(value="/span/child")
        public Response spanChild() {
            this.spanBean.spanChild();
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/childParameterWithParameter/{name}")
        public Response spanChildWithParameter(@PathParam(value="name") String name) {
            this.spanBean.spanChildWithParameter(name);
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/current")
        public Response spanCurrent() {
            this.span.setAttribute("tck.current.key", "tck.current.value");
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/new")
        public Response spanNew() {
            Span span = this.tracer.spanBuilder("span.new").setSpanKind(SpanKind.INTERNAL).setParent(Context.current().with((ImplicitContextKeyed)this.span)).setAttribute("tck.new.key", "tck.new.value").startSpan();
            span.end();
            return Response.ok().build();
        }

        @GET
        @Path(value="span/clienterror")
        public Response spanClientError() {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

