/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.compiler.EmftvmCompilerPlugin;
import org.eclipse.m2m.atl.emftvm.util.DefaultModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.engine.ProblemConverter;
import org.eclipse.m2m.atl.engine.compiler.AtlStandaloneCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompileTimeError;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlToEmftvmCompiler
implements AtlStandaloneCompiler {
    protected final ResourceSet rs = new ResourceSetImpl();
    protected final Metamodel atlmm = EmftvmFactory.eINSTANCE.createMetamodel();
    protected final Metamodel pbmm = EmftvmFactory.eINSTANCE.createMetamodel();
    protected final ModuleResolver mr = new DefaultModuleResolver("platform:/plugin/org.eclipse.m2m.atl.emftvm.compiler/transformations/", this.rs);

    public AtlToEmftvmCompiler() {
        this.atlmm.setResource(((EMFReferenceModel)AtlParser.getDefault().getAtlMetamodel()).getResource());
        this.pbmm.setResource(((EMFReferenceModel)AtlParser.getDefault().getProblemMetamodel()).getResource());
    }

    public CompileTimeError[] compile(InputStream in, String outputFileName) {
        EObject[] eObjects = this.compileWithProblemModel(in, outputFileName);
        CompileTimeError[] result = new CompileTimeError[eObjects.length];
        int i = 0;
        while (i < eObjects.length) {
            result[i] = ProblemConverter.convertProblem((EObject)eObjects[i]);
            ++i;
        }
        return result;
    }

    public EObject[] compileWithProblemModel(InputStream in, String outputFileName) {
        EObject[] result = new EObject[]{};
        try {
            IFile[] outputFiles;
            File asm = new File(outputFileName);
            if (asm.exists()) {
                asm.delete();
            }
            asm.createNewFile();
            String emftvmOutputFileName = String.valueOf(outputFileName.substring(0, outputFileName.lastIndexOf(46))) + ".emftvm";
            result = this.compileWithProblemModel(in, (OutputStream)new FileOutputStream(emftvmOutputFileName));
            IFile[] iFileArray = outputFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(java.net.URI.create("file:/" + emftvmOutputFileName.replace(' ', '+')));
            int n = outputFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                file.getParent().refreshLocal(1, null);
                if (file.exists()) {
                    file.setDerived(true);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e);
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e.getStatus());
        }
        return result;
    }

    public EObject[] compileWithProblemModel(InputStream in, OutputStream outputStream) {
        ArrayList<EObject> pbs = new ArrayList<EObject>();
        try {
            IModel[] parsed = AtlParser.getDefault().parseToModelWithProblems(in, true);
            IModel atlmodel = parsed[0];
            IModel problems = parsed[1];
            if (this.getProblems(problems, pbs) == 0) {
                EObject[] cpbs;
                EObject[] eObjectArray = cpbs = this.compileWithProblemModel(atlmodel, outputStream);
                int n = cpbs.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject cpb = eObjectArray[n2];
                    pbs.add(cpb);
                    ++n2;
                }
            }
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e);
        }
        return pbs.toArray(new EObject[pbs.size()]);
    }

    public EObject[] compileWithProblemModel(IModel atlModel, OutputStream outputStream) {
        ArrayList<EObject> pbs;
        block9: {
            pbs = new ArrayList<EObject>();
            Model atlm = EmftvmFactory.eINSTANCE.createModel();
            atlm.setResource(((EMFModel)atlModel).getResource());
            Resource pr = this.rs.createResource(URI.createFileURI((String)"problems.xmi"));
            Model pbm = EmftvmFactory.eINSTANCE.createModel();
            pbm.setResource(pr);
            Resource r = this.rs.createResource(URI.createFileURI((String)"out.emftvm"), "org.eclipse.m2m.atl.emftvm");
            Model emftvmm = EmftvmFactory.eINSTANCE.createModel();
            emftvmm.setResource(r);
            Resource ri = this.rs.createResource(URI.createFileURI((String)"inlined.emftvm"), "org.eclipse.m2m.atl.emftvm");
            Model emftvmmi = EmftvmFactory.eINSTANCE.createModel();
            emftvmmi.setResource(ri);
            try {
                ExecEnv env = EmftvmFactory.eINSTANCE.createExecEnv();
                env.getMetaModels().put("ATL", this.atlmm);
                env.getMetaModels().put("Problem", this.pbmm);
                env.getInputModels().put("IN", atlm);
                env.getOutputModels().put("OUT", pbm);
                env.loadModule(this.mr, "ATLWFR");
                env.run(new TimingData(), null);
                if (this.getProblems(pbm, pbs) == 0) {
                    env = EmftvmFactory.eINSTANCE.createExecEnv();
                    env.getMetaModels().put("ATL", this.atlmm);
                    env.getMetaModels().put("Problem", this.pbmm);
                    env.getInputModels().put("IN", atlm);
                    env.getOutputModels().put("OUT", emftvmm);
                    env.getOutputModels().put("PBS", pbm);
                    env.loadModule(this.mr, "ATLtoEMFTVM");
                    env.run(new TimingData(), null);
                    if (this.getProblems(pbm, pbs) == 0) {
                        env = EmftvmFactory.eINSTANCE.createExecEnv();
                        env.getInputModels().put("IN", emftvmm);
                        env.getOutputModels().put("OUT", emftvmmi);
                        env.loadModule(this.mr, "InlineCodeblocks");
                        env.run(new TimingData(), null);
                        ri.save(outputStream, Collections.emptyMap());
                    }
                }
            }
            catch (VMException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                EmftvmCompilerPlugin.log(e);
                this.rs.getResources().remove((Object)pr);
                this.rs.getResources().remove((Object)r);
                this.rs.getResources().remove((Object)ri);
                break block9;
            }
            catch (IOException e) {
                try {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    EmftvmCompilerPlugin.log(e);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.rs.getResources().remove((Object)pr);
                    this.rs.getResources().remove((Object)r);
                    this.rs.getResources().remove((Object)ri);
                }
            }
            this.rs.getResources().remove((Object)pr);
            this.rs.getResources().remove((Object)r);
            this.rs.getResources().remove((Object)ri);
        }
        return pbs.toArray(new EObject[pbs.size()]);
    }

    public EObject[] compileWithProblemModel(IModel atlModel, String outputFileName) {
        try {
            File asm = new File(outputFileName);
            if (asm.exists()) {
                asm.delete();
            }
            asm.createNewFile();
            String emftvmOutputFileName = String.valueOf(outputFileName.substring(0, outputFileName.lastIndexOf(46))) + ".emftvm";
            return this.compileWithProblemModel(atlModel, (OutputStream)new FileOutputStream(emftvmOutputFileName));
        }
        catch (IOException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            EmftvmCompilerPlugin.log(e);
            return new EObject[0];
        }
    }

    protected int getProblems(IModel problems, Collection<EObject> pbElements) {
        Set pbs = problems.getElementsByType(problems.getReferenceModel().getMetaElementByName("Problem"));
        int nbErrors = 0;
        if (pbs != null) {
            for (EObject pb : pbs) {
                EStructuralFeature severityFeature = pb.eClass().getEStructuralFeature("severity");
                if (severityFeature == null || !"error".equals(((EEnumLiteral)pb.eGet(severityFeature)).getName())) continue;
                ++nbErrors;
            }
            pbElements.addAll(pbs);
        }
        return nbErrors;
    }

    protected int getProblems(Model problems, Collection<EObject> pbElements) {
        LazyList pbs = problems.allInstancesOf((EClass)this.pbmm.findType("Problem"));
        int nbErrors = 0;
        if (pbs != null) {
            for (EObject pb : pbs) {
                EStructuralFeature severityFeature = pb.eClass().getEStructuralFeature("severity");
                if (severityFeature == null || !"error".equals(((EEnumLiteral)pb.eGet(severityFeature)).getName())) continue;
                ++nbErrors;
            }
            pbElements.addAll((Collection<EObject>)pbs);
        }
        return nbErrors;
    }
}

