/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt;

import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.atl.adt.Messages;
import org.eclipse.m2m.atl.common.ATLLogger;

public class AtlCleanVisitor
implements IResourceVisitor {
    private IProgressMonitor monitor;

    public AtlCleanVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean hasAsmFile(IResource resource) {
        return this.getAsmFile(resource).exists();
    }

    private IFile getAsmFile(IResource resource) {
        String atlFileName = resource.getName();
        String asmFileName = String.valueOf(atlFileName.substring(0, atlFileName.lastIndexOf(46))) + ".asm";
        IFile asm = resource.getParent().getFile((IPath)new Path(asmFileName));
        return asm;
    }

    public boolean visit(IResource resource) throws CoreException {
        String extension = resource.getFileExtension();
        if ("atl".equals(extension) && resource instanceof IFile && ((IFile)resource).getLocation().toFile().length() > 0L && this.hasAsmFile(resource)) {
            this.monitor.subTask(Messages.getString("AtlCleanVisitor.CLEANTASK", new Object[]{resource.getName()}));
            IFile asmFile = this.getAsmFile(resource);
            try {
                asmFile.delete(true, this.monitor);
            }
            catch (CoreException ce) {
                ATLLogger.log((Level)Level.SEVERE, (String)ce.getLocalizedMessage(), (Throwable)ce);
                return false;
            }
        }
        return true;
    }
}

