/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.m2m.atl.tests.util.FileUtils;
import org.eclipse.m2m.atl.tests.util.ModelUtils;

public final class InitParserData {
    protected static boolean update;

    private InitParserData() {
    }

    public static void main(String[] args) {
        File expDir = new File("data/expected");
        File[] directories = FileUtils.listDirectories(expDir);
        try {
            if (directories != null) {
                int i = 0;
                while (i < directories.length) {
                    InitParserData.initSnapshots(directories[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initSnapshots(File directory) throws Exception {
        if (FileUtils.listDirectories(directory).length != 0) {
            int i = 0;
            while (i < FileUtils.listDirectories(directory).length) {
                InitParserData.initSnapshots(FileUtils.listDirectories(directory)[i]);
                ++i;
            }
        } else {
            InitParserData.initTest(directory);
        }
    }

    private static void initTest(File directory) throws Exception {
        String transfoPath = String.valueOf(directory.toString().replaceAll("expected", "inputs")) + "/" + directory.getName() + ".atl";
        String xmiTransfoPath = String.valueOf(directory.toString()) + "/" + directory.getName() + ".atl.xmi";
        if (!new File(transfoPath).exists()) {
            return;
        }
        if (new File(xmiTransfoPath).exists() && !update) {
            return;
        }
        EObject result = AtlParser.getDefault().parse((InputStream)new FileInputStream(transfoPath));
        ModelUtils.save(result, xmiTransfoPath);
        System.out.println(String.valueOf(transfoPath) + " extracted.\n");
    }
}

