/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.actions.FormatCodeAction;
import org.eclipse.m2m.atl.adt.ui.actions.IndentAction;
import org.eclipse.m2m.atl.adt.ui.actions.ToggleCommentAction;
import org.eclipse.m2m.atl.adt.ui.editor.AtlOccurrencesFinder;
import org.eclipse.m2m.atl.adt.ui.editor.IOccurrencesFinder;
import org.eclipse.m2m.atl.adt.ui.editor.Messages;
import org.eclipse.m2m.atl.adt.ui.outline.AtlContentOutlinePage;
import org.eclipse.m2m.atl.adt.ui.outline.AtlEMFConstants;
import org.eclipse.m2m.atl.adt.ui.properties.AtlPropertySourceProvider;
import org.eclipse.m2m.atl.adt.ui.text.AtlContentAssistPreference;
import org.eclipse.m2m.atl.adt.ui.text.AtlPairMatcher;
import org.eclipse.m2m.atl.adt.ui.text.AtlSourceViewerConfiguration;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.LastSaveComparator;
import org.eclipse.m2m.atl.adt.ui.text.atl.OpenDeclarationUtils;
import org.eclipse.m2m.atl.adt.ui.viewsupport.AtlEditorTickErrorUpdater;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.common.AtlNbCharFile;
import org.eclipse.m2m.atl.common.IAtlLexems;
import org.eclipse.m2m.atl.debug.core.AtlBreakpoint;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlEditor
extends TextEditor {
    private ProjectionSupport projectionSupport;
    protected AtlPairMatcher bracketMatcher = new AtlPairMatcher(IAtlLexems.BRACKETS);
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private BracketInserter fBracketInserter = new BracketInserter();
    private TabConverter fTabConverter;
    private AtlSourceManager sourceManager;
    private AtlModelAnalyser analyser;
    private LastSaveComparator comparator;
    private Annotation[] fOccurrenceAnnotations = null;
    private ISelection fForcedMarkOccurrencesSelection;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private AtlNbCharFile help;
    private AtlContentOutlinePage outlinePage;
    private PropertySheetPage propertySheetPage;
    private SelectionChangedListener selectionChangedListener;
    private AtlEditorTickErrorUpdater tickErrorUpdater;
    private ProjectionAnnotationModel annotationModel;

    public static String getCurrentLine(IDocument document, int offset) {
        try {
            if (offset >= 0) {
                int lineNumber = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNumber);
                return document.get(lineOffset, offset - lineOffset);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void updateOccurrenceAnnotations(ITextSelection selection) {
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        boolean hasChanged = false;
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            String currentLine = AtlEditor.getCurrentLine(document, offset);
            if (currentLine != null && currentLine.contains("--")) {
                return;
            }
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion;
            boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp;
            if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = OpenDeclarationUtils.findWord(document, offset);
            if (this.fMarkOccurrenceTargetRegion == null || this.fMarkOccurrenceTargetRegion.getLength() <= 0) {
                return;
            }
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        AtlOccurrencesFinder finder = new AtlOccurrencesFinder(this, document);
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        if (finder.initialize(this.fMarkOccurrenceTargetRegion) == null) {
            locations = finder.getOccurrences();
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, locations, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != IAtlLexems.BRACKETS.length) {
            if (character == IAtlLexems.BRACKETS[i].toCharArray()[0]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return AtlEditor.isBracket(document.getChar(offset - 1)) && AtlEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public AtlEditor() {
        this.setPreferenceStore(AtlUIPlugin.getDefault().getPreferenceStore());
        this.tickErrorUpdater = new AtlEditorTickErrorUpdater(this);
        this.sourceManager = new AtlSourceManager();
        this.comparator = new LastSaveComparator(this);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AtlSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("Atl.AppearanceHighlightMatchingBrackets", "Atl.AppearanceHighlightMatchingBrackets.Color");
        super.configureSourceViewerDecorationSupport(support);
    }

    private void configureTabConverter() {
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = Messages.getResourceBundle();
        TextEditorAction action = new IndentAction(resourceBundle, "Indent.", (ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.m2m.atl.adt.ui.actions.Indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        action = new IndentAction(Messages.getResourceBundle(), "Indent.", (ITextEditor)this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        if (this.getPreferenceStore().getBoolean("Atl.Typing.SmartTab")) {
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
        this.installContentAssistAction();
        action = new ToggleCommentAction(Messages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("atlCommands.commentBlock");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        action = new FormatCodeAction(Messages.getResourceBundle(), "FormatCode.", (ITextEditor)this);
        action.setActionDefinitionId("atlCommands.formatCode");
        this.setAction("FormatCode", (IAction)action);
        this.markAsStateDependentAction("FormatCode", true);
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    private void installContentAssistAction() {
        ResourceBundle resourceBundle = Messages.getResourceBundle();
        ContentAssistAction action = new ContentAssistAction(resourceBundle, "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    protected AtlContentOutlinePage createOutlinePage() {
        AtlContentOutlinePage page = new AtlContentOutlinePage((ITextEditor)this, this.getEditorInput(), this.getDocumentProvider());
        this.selectionChangedListener = new SelectionChangedListener();
        page.addPostSelectionChangedListener(this.selectionChangedListener);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.editorSelectionChangedListener = new EditorSelectionChangedListener();
        IPostSelectionProvider editorSelectionProvider = (IPostSelectionProvider)this.getSelectionProvider();
        editorSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this.editorSelectionChangedListener);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.fBracketInserter.setCloseBracketsEnabled(preferenceStore.getBoolean("Atl.Typing.ClolseBrackets"));
        this.fBracketInserter.setCloseStringsEnabled(preferenceStore.getBoolean("Atl.Typing.CloseStrings"));
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    public void updateFoldingStructure(Map<Annotation, Position> addedAnnotations, List<Annotation> deletedAnnotations, Map<Annotation, Position> modifiedAnnotations) {
        Annotation[] deleted = new Annotation[deletedAnnotations.size() + modifiedAnnotations.size()];
        int i = 0;
        while (i < deletedAnnotations.size()) {
            deleted[i] = deletedAnnotations.get(i);
            ++i;
        }
        Iterator<Annotation> modifiedIterator = modifiedAnnotations.keySet().iterator();
        int i2 = deletedAnnotations.size();
        while (i2 < deleted.length) {
            deleted[i2] = modifiedIterator.next();
            ++i2;
        }
        addedAnnotations.putAll(modifiedAnnotations);
        if (this.annotationModel != null) {
            this.annotationModel.modifyAnnotations(deleted, addedAnnotations, null);
        }
    }

    protected PropertySheetPage createPropertySheetPage() {
        PropertySheetPage page = new PropertySheetPage();
        AtlPropertySourceProvider apsp = new AtlPropertySourceProvider();
        page.setPropertySourceProvider((IPropertySourceProvider)apsp);
        return page;
    }

    public void dispose() {
        super.dispose();
        this.tickErrorUpdater.dispose();
        if (this.bracketMatcher != null) {
            this.bracketMatcher.dispose();
            this.bracketMatcher = null;
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.sourceManager.updateDataSource(this.getDocumentProviderContent());
        this.analyser = new AtlModelAnalyser(new AtlCompletionHelper(this.getDocumentProviderContent()), this.sourceManager.getModel(), 0, AtlCompletionDataSource.getATLFileContext(this.sourceManager));
        this.comparator.markAsSave();
        if (this.outlinePage != null) {
            this.outlinePage.setUnit();
        }
    }

    public AtlPairMatcher getBracketMatcher() {
        return this.bracketMatcher;
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        if (this.isAtlOutlinePageActive()) {
            this.setSelection(event);
        }
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
            }
            return this.outlinePage;
        }
        if (IPropertySheetPage.class.equals((Object)required)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            return this.propertySheetPage;
        }
        return super.getAdapter(required);
    }

    public String getDocumentProviderContent() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    public String getEditorInputContent() {
        StringBuffer content;
        block15: {
            IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
            IFile ifi = editorInput.getFile();
            content = new StringBuffer();
            InputStream is = null;
            try {
                try {
                    int c;
                    is = ifi.getContents();
                    while ((c = is.read()) != -1) {
                        content.append((char)c);
                    }
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e1) {
                            ATLLogger.log((Level)Level.SEVERE, (String)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e1.getLocalizedMessage(), (Throwable)e1);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
        return content.toString();
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = AtlEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public IResource getUnderlyingResource() {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        if (input == null) {
            return null;
        }
        return input.getFile();
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(Messages.getString("GotoMatchingBracket.error.invalidSelection"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (AtlEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.bracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(Messages.getString("GotoMatchingBracket.error.noMatchingBracket"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.bracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(Messages.getString("GotoMatchingBracket.error.bracketOutsideSelectedElement"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            IContentAssistant c;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) return;
            String property = event.getProperty();
            AtlSourceViewerConfiguration sourceViewerConfiguration = (AtlSourceViewerConfiguration)this.getSourceViewerConfiguration();
            sourceViewerConfiguration.handlePropertyChangeEvent(event);
            if ("Atl.Typing.ClolseBrackets".equals(property)) {
                this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(property));
                return;
            }
            if ("Atl.Typing.CloseStrings".equals(property)) {
                this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(property));
                return;
            }
            if ("Atl.Typing.SpacesForTabs".equals(property)) {
                if (this.isTabConversionEnabled()) {
                    this.startTabConversion();
                    return;
                }
                this.stopTabConversion();
                return;
            }
            if ("Atl.Typing.SmartTab".equals(property)) {
                if (this.getPreferenceStore().getBoolean("Atl.Typing.SmartTab")) {
                    this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
                } else {
                    this.removeActionActivationCode("IndentOnTab");
                }
            }
            if (!((c = sourceViewerConfiguration.getContentAssistant(sourceViewer)) instanceof ContentAssistant)) return;
            AtlContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
            return;
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.tickErrorUpdater.updateEditorImage(this.getUnderlyingResource());
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AtlSourceViewerConfiguration(AtlUIPlugin.getDefault().getTextTools(), (ITextEditor)this));
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals((Object)this);
    }

    private boolean isAtlOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.outlinePage;
    }

    private boolean isTabConversionEnabled() {
        return this.getPreferenceStore().getBoolean("Atl.Typing.SpacesForTabs");
    }

    public void setHelp(AtlNbCharFile help) {
        this.help = help;
    }

    protected void setNewPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.getSourceViewerConfiguration() instanceof AtlSourceViewerConfiguration) {
            ((AtlSourceViewerConfiguration)this.getSourceViewerConfiguration()).setNewPreferenceStore(store);
        }
    }

    private void setSelection(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else {
            EObject element = (EObject)selection.getFirstElement();
            String location = (String)element.eGet(AtlEMFConstants.sfLocation);
            if (location == null) {
                return;
            }
            int[] sl = this.help.getIndexChar(location);
            int start = sl[0];
            int length = sl[1] - sl[0];
            try {
                this.setHighlightRange(start, length, false);
                this.selectAndReveal(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.resetHighlightRange();
            }
        }
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("tabWidth"));
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            this.fTabConverter = null;
        }
    }

    public void synchronizeOutlinePageSelection() {
        if (this.isActivePart() && this.outlinePage != null) {
            this.outlinePage.removePostSelectionChangedListener(this.selectionChangedListener);
            this.outlinePage.setSelection(this.getCursorPosition());
            this.outlinePage.addPostSelectionChangedListener(this.selectionChangedListener);
        }
    }

    public void updateTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public AtlContentOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void toggleLineBreakpoints(ISelection selection) throws CoreException {
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        int offset = textSelection.getOffset();
        if (offset == -1) {
            return;
        }
        EObject element = this.getDebugElement(lineNumber);
        if (element != null) {
            String location = (String)element.eGet(AtlEMFConstants.sfLocation);
            int[] pos = this.help.getIndexChar(location);
            int charStart = pos[0];
            int charEnd = pos[1];
            int elementLineNumber = Integer.parseInt(location.split("-")[0].split(":")[0]);
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.m2m.atl.adt.debug");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource())) {
                    int bLineNumber = ((ILineBreakpoint)breakpoint).getLineNumber();
                    int bCharStart = ((ILineBreakpoint)breakpoint).getCharStart();
                    int bCharEnd = ((ILineBreakpoint)breakpoint).getCharEnd();
                    if (bLineNumber == elementLineNumber || bCharStart == charStart || charStart <= bCharStart && charEnd >= bCharEnd) {
                        breakpoint.delete();
                        return;
                    }
                }
                ++i;
            }
            new AtlBreakpoint(resource, location, elementLineNumber, charStart, charEnd);
        }
    }

    public void toggleLineBreakpoints(EObject element) throws CoreException {
        IResource resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (element != null) {
            String location = (String)element.eGet(AtlEMFConstants.sfLocation);
            int[] pos = this.help.getIndexChar(location);
            int charStart = pos[0];
            int charEnd = pos[1];
            int elementLineNumber = Integer.parseInt(location.split("-")[0].split(":")[0]);
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.m2m.atl.adt.debug");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource())) {
                    int bLineNumber = ((ILineBreakpoint)breakpoint).getLineNumber();
                    int bCharStart = ((ILineBreakpoint)breakpoint).getCharStart();
                    int bCharEnd = ((ILineBreakpoint)breakpoint).getCharEnd();
                    if (bLineNumber == elementLineNumber || bCharStart == charStart || charStart <= bCharStart && charEnd >= bCharEnd) {
                        breakpoint.delete();
                        return;
                    }
                }
                ++i;
            }
            new AtlBreakpoint(resource, location, elementLineNumber, charStart, charEnd);
        }
    }

    public EObject getDebugElement(int lineNumber) {
        EObject res = null;
        if (this.sourceManager.getModel() != null) {
            TreeIterator ti = this.sourceManager.getModel().eAllContents();
            while (ti.hasNext()) {
                String location;
                int elementLineNumber;
                EObject object = (EObject)ti.next();
                EStructuralFeature feature = object.eClass().getEStructuralFeature("location");
                if (feature == null || (elementLineNumber = Integer.parseInt((location = (String)object.eGet(feature)).split("-")[0].split(":")[0])) != lineNumber + 1) continue;
                res = object;
            }
        }
        return res;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configureToggleCommentAction();
        if (this.tickErrorUpdater != null) {
            this.tickErrorUpdater.updateEditorImage(this.getUnderlyingResource());
        }
        this.sourceManager.updateDataSource(this.getDocumentProviderContent());
        this.analyser = new AtlModelAnalyser(new AtlCompletionHelper(this.getDocumentProviderContent()), this.sourceManager.getModel(), 0, AtlCompletionDataSource.getATLFileContext(this.sourceManager));
        this.comparator.markAsSave();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.m2m.atl.adt.editor"});
    }

    public LastSaveComparator getComparator() {
        return this.comparator;
    }

    public AtlSourceViewerConfiguration getSourceViewerConf() {
        return (AtlSourceViewerConfiguration)this.getSourceViewerConfiguration();
    }

    public AtlSourceManager getSourceManager() {
        return this.sourceManager;
    }

    public AtlModelAnalyser getModelAnalyser() {
        return this.analyser;
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private final String category = this.toString();
        private Stack<BracketLevel> fBracketLevelStack = new Stack();
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.category);

        private BracketInserter() {
        }

        private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && document.getChar(end) == character;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
            try {
                int start = offset;
                IRegion startLine = document.getLineInformationOfOffset(start);
                int minStart = startLine.getOffset();
                while (start != minStart && Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheRight(IDocument document, int offset) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = AtlEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.category);
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                    }
                });
            }
        }

        public void resume(LinkedModeModel environment, int flags) {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            ISourceViewer sourceViewer = AtlEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case '(': {
                    if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                        return;
                    }
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    if (this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                case '\'': {
                    if (event.character == '\'') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                }
                case '\"': {
                    if (event.character == '\"') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                    try {
                        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"partitioning", (int)offset, (boolean)true);
                        if (!"__dftl_partition_content_type".equals(partition.getType())) {
                            return;
                        }
                        if (!AtlEditor.this.validateEditorInputState()) {
                            return;
                        }
                        char character = event.character;
                        char closingCharacter = AtlEditor.getPeerCharacter(character);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(character);
                        buffer.append(closingCharacter);
                        document.replace(offset, length, buffer.toString());
                        BracketLevel level = new BracketLevel();
                        this.fBracketLevelStack.push(level);
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                        LinkedModeModel model = new LinkedModeModel();
                        model.addLinkingListener((ILinkedModeListener)this);
                        model.addGroup(group);
                        model.forceInstall();
                        level.fOffset = offset;
                        level.fLength = 2;
                        if (this.fBracketLevelStack.size() == 1) {
                            document.addPositionCategory(this.category);
                            document.addPositionUpdater(this.fUpdater);
                        }
                        level.fFirstPosition = new Position(offset, 1);
                        level.fSecondPosition = new Position(offset + 1, 1);
                        document.addPosition(this.category, level.fFirstPosition);
                        document.addPosition(this.category, level.fSecondPosition);
                        level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                        level.fUI.setSimpleMode(true);
                        level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, AtlEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                        level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                        level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                        level.fUI.enter();
                        IRegion newSelection = level.fUI.getSelectedRegion();
                        sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                        event.doit = false;
                        break;
                    }
                    catch (BadLocationException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                        break;
                    }
                    catch (BadPositionCategoryException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected static class BracketLevel {
        Position fFirstPosition;
        int fLength;
        int fOffset;
        Position fSecondPosition;
        LinkedModeUI fUI;

        protected BracketLevel() {
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AtlEditor.this.synchronizeOutlinePageSelection();
            AtlEditor.this.updateOccurrenceAnnotations((ITextSelection)event.getSelection());
        }
    }

    protected static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public String getCategory() {
            return this.fCategory;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fEscapeCharacter;
        final char fExitCharacter;
        final int fSize;
        final Stack<BracketLevel> fStack;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack<BracketLevel> stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                BracketLevel level = this.fStack.peek();
                if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                    return null;
                }
                if (level.fSecondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = AtlEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private final ISelection fSelection;
        private final ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private final IOccurrencesFinder.OccurrenceLocation[] fLocations;

        public OccurrencesFinderJob(IDocument document, IOccurrencesFinder.OccurrenceLocation[] locations, ISelection selection) {
            super("");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fLocations = locations;
            this.fPostSelectionValidator = AtlEditor.this.getSelectionProvider() instanceof ISelectionValidator ? (ISelectionValidator)AtlEditor.this.getSelectionProvider() : null;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && AtlEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.fLocations == null || this.fLocations.length <= 0) {
                return null;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = AtlEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = AtlEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)AtlEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fLocations.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                if (this.isCanceled(progressMonitor)) {
                    return Status.CANCEL_STATUS;
                }
                IOccurrencesFinder.OccurrenceLocation location = this.fLocations[i];
                Position position = new Position(location.getOffset(), location.getLength());
                String description = location.getDescription();
                String annotationType = location.getFlags() == 1 ? "org.eclipse.jdt.ui.occurrences.write" : "org.eclipse.jdt.ui.occurrences";
                annotationMap.put(new Annotation(annotationType, false, description), position);
                ++i;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = AtlEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(AtlEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                AtlEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AtlEditor.this.doSelectionChanged(event);
        }
    }

    static class TabConverter
    implements ITextConverter {
        private ILineTracker fLineTracker;
        private int fTabRatio;

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }
    }
}

