/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.Correlator;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.RegionMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.NamedMappingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class LateConsumerMerger
extends AbstractMerger {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull RootPartition rootPartition;
    protected final @NonNull List<@NonNull Region> allRegions = new ArrayList<Region>();
    private ContentsAnalysis<@NonNull MappingRegion> contentsAnalysis;
    private final @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> mergedRegion2originalRegions = new HashMap<MappingRegion, List<MappingRegion>>();
    protected final @NonNull LateStrategy LateStrategy_INSTANCE = new LateStrategy();

    public static @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> merge(@NonNull ScheduleManager scheduleManager, @NonNull RootPartition rootPartition) {
        LateConsumerMerger lateMerger = new LateConsumerMerger(scheduleManager, rootPartition);
        lateMerger.merge();
        lateMerger.prune();
        scheduleManager.writeDebugGraphs("8-late", true, true, false);
        return lateMerger.getMerges();
    }

    public LateConsumerMerger(@NonNull ScheduleManager scheduleManager, @NonNull RootPartition rootPartition) {
        this.scheduleManager = scheduleManager;
        this.rootPartition = rootPartition;
        this.gatherRegions((Region)rootPartition.getScheduledRegion());
    }

    private void gatherRegions(@NonNull Region parentRegion) {
        for (Region childRegion : parentRegion.getCallableChildren()) {
            this.allRegions.add(childRegion);
            this.gatherRegions(childRegion);
        }
    }

    protected @NonNull ContentsAnalysis<@NonNull MappingRegion> getContentsAnalysis() {
        ContentsAnalysis<@NonNull Object> contentsAnalysis2 = this.contentsAnalysis;
        if (contentsAnalysis2 == null) {
            this.contentsAnalysis = new ContentsAnalysis(this.scheduleManager);
            contentsAnalysis2 = this.contentsAnalysis;
            for (Region region : this.allRegions) {
                if (!(region instanceof MappingRegion)) continue;
                contentsAnalysis2.addRegion((MappingRegion)region);
            }
        }
        return contentsAnalysis2;
    }

    public @NonNull Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> getMerges() {
        return this.mergedRegion2originalRegions;
    }

    private void merge() {
        this.mergeHierarchy((Region)this.rootPartition.getScheduledRegion());
    }

    private void mergeHierarchy(@NonNull Region parentRegion) {
        for (Region childRegion : parentRegion.getCallableChildren()) {
            this.mergeHierarchy(childRegion);
            this.mergeRegion(childRegion);
        }
    }

    private void mergeRegion(@NonNull Region parentRegion) {
        for (NodeConnection nodeConnection : parentRegion.getRootConnections()) {
            Iterable<@NonNull List<@NonNull MappingRegion>> consecutiveRegionRuns = this.selectConsecutiveRegionRuns(nodeConnection);
            for (List<MappingRegion> consecutiveRegionRun : consecutiveRegionRuns) {
                StringBuilder s = new StringBuilder();
                s.append(Iterables.size(consecutiveRegionRun));
                for (Region region : consecutiveRegionRun) {
                    s.append(" " + region);
                }
                this.mergeRegions(consecutiveRegionRun);
            }
        }
    }

    protected void mergeRegions(@NonNull List<@NonNull MappingRegion> consecutiveRegionRun) {
        ArrayList<@NonNull MappingRegion> residualInputRegions = new ArrayList<MappingRegion>(consecutiveRegionRun);
        while (residualInputRegions.size() >= 2) {
            MappingRegion primaryRegion = (MappingRegion)residualInputRegions.remove(0);
            if (LATE.isActive()) {
                LATE.println("Correlating primary: " + primaryRegion + "@[" + primaryRegion.getIndexRangeText() + "]");
            }
            if (primaryRegion.getIntermediateConnections().size() > 0) {
                if (FAILURE.isActive()) {
                    FAILURE.println("Intermediate connections not yet supported");
                }
                return;
            }
            RegionMerger regionMerger = null;
            int i = 0;
            while (i < residualInputRegions.size()) {
                MappingRegion secondaryRegion = (MappingRegion)residualInputRegions.get(i);
                if (LATE.isActive()) {
                    LATE.println("Correlating secondary: " + secondaryRegion + "@[" + secondaryRegion.getIndexRangeText() + "]");
                }
                if (secondaryRegion.getIntermediateConnections().size() > 0) {
                    if (FAILURE.isActive()) {
                        FAILURE.println("Intermediate connections not yet supported");
                    }
                } else {
                    RegionMerger regionMerger2 = regionMerger != null ? regionMerger : new LateRegionMerger(this.scheduleManager, primaryRegion);
                    Correlator forwardCorrelator = Correlator.correlate(regionMerger2, secondaryRegion, this.LateStrategy_INSTANCE, null);
                    if (forwardCorrelator != null) {
                        boolean doMerge = false;
                        if (!this.isSharedHead((Region)primaryRegion, (Region)secondaryRegion)) {
                            doMerge = false;
                        } else {
                            LateRegionMerger reverseRegionMerger;
                            if (LATE.isActive()) {
                                LATE.println("Correlating inverse");
                            }
                            if (Correlator.correlate(reverseRegionMerger = new LateRegionMerger(this.scheduleManager, secondaryRegion), primaryRegion, this.LateStrategy_INSTANCE, forwardCorrelator) != null) {
                                doMerge = true;
                            }
                        }
                        if (doMerge) {
                            if (regionMerger == null) {
                                regionMerger = regionMerger2;
                            }
                            regionMerger.addSecondaryRegion(secondaryRegion, forwardCorrelator);
                        }
                    }
                }
                ++i;
            }
            if (regionMerger == null) continue;
            regionMerger.prune();
            MappingRegion mergedRegion = regionMerger.create();
            regionMerger.check(mergedRegion);
            ((LateRegionMerger)regionMerger).install(this.getContentsAnalysis(), mergedRegion);
            ArrayList<@NonNull MappingRegion> originalRegions = new ArrayList<MappingRegion>();
            originalRegions.addAll(regionMerger.getOriginalRegions());
            this.mergedRegion2originalRegions.put(mergedRegion, originalRegions);
            residualInputRegions.removeAll(originalRegions);
            for (Region region : originalRegions) {
                Iterator iterator = region.getIndexes().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    mergedRegion.addIndex(index);
                }
            }
            this.scheduleManager.writeDebugGraphs((Graphable)mergedRegion, null);
        }
    }

    private void prune() {
        for (List<MappingRegion> originalRegions : this.mergedRegion2originalRegions.values()) {
            for (MappingRegion mappingRegion : originalRegions) {
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull List<@NonNull MappingRegion>> selectConsecutiveRegionRuns(@NonNull NodeConnection nodeConnection) {
        HashMap<@NonNull Integer, @NonNull MappingRegion> index2region = new HashMap<Integer, MappingRegion>();
        for (Region targetRegion : nodeConnection.getTargetRegions()) {
            if (!(targetRegion instanceof MappingRegion)) continue;
            @NonNull List indexes = targetRegion.getIndexes();
            index2region.put((Integer)indexes.get(indexes.size() - 1), (MappingRegion)targetRegion);
        }
        ArrayList<@NonNull K> orderedIndexes = new ArrayList(index2region.keySet());
        Collections.sort(orderedIndexes);
        ArrayList<@NonNull List<@NonNull MappingRegion>> consecutiveRegionRuns = new ArrayList<List<MappingRegion>>();
        ArrayList<MappingRegion> consecutiveRegionRun = null;
        for (Integer index : orderedIndexes) {
            MappingRegion childRegion = (MappingRegion)index2region.get(index);
            assert (childRegion != null);
            if (consecutiveRegionRun == null || ((MappingRegion)consecutiveRegionRun.get(consecutiveRegionRun.size() - 1)).getLastIndex() + 1 != index) {
                consecutiveRegionRun = new ArrayList<MappingRegion>();
                consecutiveRegionRuns.add(consecutiveRegionRun);
            }
            consecutiveRegionRun.add(childRegion);
        }
        int i = consecutiveRegionRuns.size();
        while (--i >= 0) {
            @NonNull List consecutiveRegionRun2 = (List)consecutiveRegionRuns.get(i);
            if (consecutiveRegionRun2.size() > 1) continue;
            consecutiveRegionRuns.remove(i);
        }
        return consecutiveRegionRuns;
    }

    public static class LateMergedMappingRegion
    extends NamedMappingRegionImpl {
        public LateMergedMappingRegion(@NonNull ScheduleManager scheduleManager, @NonNull String name) {
            scheduleManager.addMappingRegion((MappingRegion)this);
            this.setName(name);
            this.setSymbolNameSuffix("_lc");
        }
    }

    protected static class LateRegionMerger
    extends RegionMerger {
        protected LateRegionMerger(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion primaryRegion) {
            super(scheduleManager, primaryRegion);
        }

        @Override
        protected @NonNull MappingRegion createMergedRegion(@NonNull String mergedName) {
            return new LateMergedMappingRegion(this.scheduleManager, mergedName);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void install(@NonNull ContentsAnalysis<@NonNull MappingRegion> contentsAnalysis, @NonNull MappingRegion mergedRegion) {
            MappingRegion primaryRegion = this.getPrimaryRegion();
            ScheduledRegion invokingRegion = QVTscheduleUtil.getContainingScheduledRegion((Region)primaryRegion);
            @NonNull ArrayList callableParents = Lists.newArrayList((Iterable)primaryRegion.getCallableParents());
            for (MappingRegion originalRegion : this.getOriginalRegions()) {
                contentsAnalysis.removeRegion(originalRegion);
                assert (invokingRegion == originalRegion.getScheduledRegion());
                for (Region callableParent : callableParents) {
                    if (originalRegion == primaryRegion) {
                        callableParent.replaceCallToChild((Region)primaryRegion, (Region)mergedRegion);
                        continue;
                    }
                    callableParent.removeCallToChild((Region)originalRegion);
                }
                this.scheduleManager.setScheduledRegion(originalRegion, invokingRegion);
            }
            contentsAnalysis.addRegion(mergedRegion);
            this.scheduleManager.setScheduledRegion(mergedRegion, invokingRegion);
            for (Node originalHeadNode : QVTscheduleUtil.getHeadNodes((Region)primaryRegion)) {
                NodeConnection incomingConnection = originalHeadNode.getIncomingConnection();
                if (incomingConnection == null) continue;
                Node mergedHeadNode = this.getNodeMerger(originalHeadNode).getMergedNode();
                incomingConnection.addPassedTargetNode(mergedHeadNode);
                for (Region region : this.getOriginalRegions()) {
                    incomingConnection.removeTargetRegion(region);
                }
            }
        }
    }

    private class LateStrategy
    extends Correlator.AbstractCorrelationStrategy {
        private LateStrategy() {
        }

        @Override
        public boolean navigableEdgesMatch(@Nullable EdgeMerger edgeMerger, @NonNull NavigableEdge extraEdge) {
            if (extraEdge.isSecondary()) {
                return true;
            }
            Property property = extraEdge.getProperty();
            if (edgeMerger == null) {
                if (!extraEdge.isMatched()) {
                    return true;
                }
                if (property.isIsMany() && ((CollectionType)property.getType()).getLower().intValue() == 0) {
                    return true;
                }
                if (extraEdge.isConstant()) {
                    if (this.debugFailures) {
                        FAILURE.println("Missing constant : " + extraEdge);
                    }
                    return false;
                }
                if (extraEdge.isLoaded()) {
                    if (this.debugFailures) {
                        FAILURE.println("Missing loaded : " + extraEdge);
                    }
                    return false;
                }
                if (extraEdge.isNew()) {
                    return true;
                }
                if (extraEdge.isOld()) {
                    if (!extraEdge.getEdgeTarget().isRequired()) {
                        return true;
                    }
                    if (!property.isIsRequired()) {
                        return true;
                    }
                    ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)extraEdge.getEdgeTarget());
                    Iterable<@NonNull NavigableEdge> realizedEdges = LateConsumerMerger.this.getContentsAnalysis().getNewEdges(extraEdge, classDatum);
                    if (realizedEdges != null) {
                        int firstIndex = extraEdge.getOwningRegion().getFirstIndex();
                        for (NavigableEdge realizedEdge : realizedEdges) {
                            Region region = realizedEdge.getOwningRegion();
                            int lastIndex = region.getLastIndex();
                            if (lastIndex < firstIndex) continue;
                            if (this.debugFailures) {
                                FAILURE.println("Not ready : " + realizedEdge);
                            }
                            return false;
                        }
                        return true;
                    }
                    this.toString();
                }
                if (this.debugFailures) {
                    FAILURE.println("Missing predicated match for : " + extraEdge);
                }
                return false;
            }
            assert (edgeMerger.getProperty() == property);
            if (!edgeMerger.isUnconditional()) {
                return true;
            }
            if (extraEdge.isConstant() || edgeMerger.isConstant()) {
                if (extraEdge.isConstant() != edgeMerger.isConstant()) {
                    System.out.println("Inconsistent constant: " + extraEdge + ", " + edgeMerger);
                }
                return true;
            }
            if (extraEdge.isLoaded() || edgeMerger.isLoaded()) {
                if (extraEdge.isLoaded() != edgeMerger.isLoaded()) {
                    System.out.println("Inconsistent loaded: " + extraEdge + ", " + edgeMerger);
                }
                return true;
            }
            if (extraEdge.isNew() || edgeMerger.isNew()) {
                if (extraEdge.isNew() == edgeMerger.isNew()) {
                    System.out.println("Inconsistent new: " + extraEdge + ", " + edgeMerger);
                }
                return true;
            }
            if (extraEdge.isOld() || edgeMerger.isOld()) {
                if (extraEdge.isOld() != edgeMerger.isOld()) {
                    System.out.println("Inconsistent old: " + extraEdge + ", " + edgeMerger);
                }
                return true;
            }
            if (this.debugFailures) {
                FAILURE.println("Inconsistent edges : " + extraEdge + ", " + edgeMerger);
            }
            return false;
        }

        @Override
        public boolean navigableNodesMatch(@Nullable NodeMerger nodeMerger, @NonNull Node extraNode) {
            if (!extraNode.isRequired() || !extraNode.isUnconditional()) {
                return true;
            }
            if (nodeMerger == null) {
                return true;
            }
            if (!nodeMerger.isRequired() || !nodeMerger.isUnconditional()) {
                return true;
            }
            if (extraNode.isConstant() || nodeMerger.isConstant()) {
                if (extraNode.isConstant() != nodeMerger.isConstant()) {
                    System.out.println("Inconsistent constant: " + extraNode + ", " + nodeMerger);
                }
                return true;
            }
            if (extraNode.isLoaded() || nodeMerger.isLoaded()) {
                if (extraNode.isLoaded() != nodeMerger.isLoaded()) {
                    System.out.println("Inconsistent loaded: " + extraNode + ", " + nodeMerger);
                }
                return true;
            }
            if (extraNode.isNew() || nodeMerger.isNew()) {
                if (extraNode.isNew() == nodeMerger.isNew()) {
                    System.out.println("Inconsistent new: " + extraNode + ", " + nodeMerger);
                }
                return true;
            }
            if (extraNode.isOld() || nodeMerger.isOld()) {
                if (extraNode.isOld() != nodeMerger.isOld()) {
                    System.out.println("Inconsistent old: " + extraNode + ", " + nodeMerger);
                }
                return true;
            }
            if (this.debugFailures) {
                FAILURE.println("Inconsistent nodes : " + extraNode + ", " + nodeMerger);
            }
            return false;
        }
    }
}

