/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.EClassAnalysis;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;

public abstract class AbstractTypedModelInstance
implements TypedModelInstance {
    private static final @NonNull List<@NonNull Object> EMPTY_EOBJECT_LIST = Collections.emptyList();
    protected final @NonNull ModelsManager modelsManager;
    protected final @NonNull String name;
    private @Nullable List<@NonNull Resource> inputResources = null;
    @Deprecated
    private @Nullable List<@NonNull EObject> inputObjects;
    protected final @NonNull List<@NonNull EObject> rootObjects = new ArrayList<EObject>();
    private int extentClassIndex = -1;
    protected @Nullable Map<Object, Object> extentOpposites = null;
    protected @NonNull Connection[] classIndex2connection;
    protected @NonNull ClassId @Nullable [] classIndex2classId = null;
    protected @Nullable Map<@NonNull ClassId, @NonNull Integer> classId2classIndex = null;
    private @Nullable Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes = null;
    private @Nullable List<@NonNull EObject> potentialOrphanObjects = null;
    protected int isContainedCount = 0;
    protected int isNotContainedCount = 0;
    private @Nullable Boolean trackAdditions = null;
    private @Nullable List<@NonNull Resource> outputResources = null;
    private @Nullable EClassAnalysis @Nullable [] eClassAnalysisListHeads;

    protected AbstractTypedModelInstance(@NonNull ModelsManager modelsManager, @NonNull String name) {
        this.modelsManager = modelsManager;
        this.name = name;
        this.eClassAnalysisListHeads = null;
    }

    @Override
    public void add(@NonNull EObject eObject, boolean isContained) {
        if (this.trackAdditions == Boolean.FALSE || isContained && this.trackAdditions == null) {
            ++this.isContainedCount;
        } else {
            ++this.isNotContainedCount;
            List<@NonNull EObject> potentialOrphanObjects2 = this.potentialOrphanObjects;
            if (potentialOrphanObjects2 == null) {
                this.potentialOrphanObjects = potentialOrphanObjects2 = new ArrayList<EObject>();
            }
            assert (!potentialOrphanObjects2.contains(eObject));
            potentialOrphanObjects2.add(eObject);
        }
        if (this.classIndex2classId != null) {
            this.getEClassAnalysis(eObject).propagate(eObject);
        }
    }

    protected abstract void addExtent();

    protected void addExtent(@NonNull EObject extent, @NonNull List<Object> elements) {
        elements.addAll(this.rootObjects);
        this.getEClassAnalysis(extent).propagate(extent);
        Map<Object, Object> extentOpposites2 = this.extentOpposites;
        if (extentOpposites2 != null) {
            for (Object object : elements) {
                extentOpposites2.put(object, extent);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addInputResource(@NonNull Resource inputResource) {
        @NonNull UniqueList inputResources2 = this.inputResources;
        if (inputResources2 == null) {
            this.inputResources = inputResources2 = new UniqueList();
        }
        inputResources2.add((Resource)inputResource);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addOutputResource(@NonNull Resource outputResource) {
        @NonNull UniqueList outputResources2 = this.outputResources;
        if (outputResources2 == null) {
            this.outputResources = outputResources2 = new UniqueList();
        }
        outputResources2.add((Resource)outputResource);
    }

    @Override
    @Deprecated
    public void addRootObjects(@NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
        List<@NonNull EObject> inputObjects2 = this.inputObjects;
        if (inputObjects2 == null) {
            this.inputObjects = inputObjects2 = new ArrayList<EObject>();
        }
        for (Object object : eRootObjects) {
            if (!(object instanceof EObject)) continue;
            inputObjects2.add((EObject)object);
        }
    }

    @Override
    public void analyzeInputResources() {
        List<@NonNull Resource> inputResources2 = this.inputResources;
        if (inputResources2 != null) {
            int i = 0;
            while (i < inputResources2.size()) {
                @NonNull Resource inputResource = inputResources2.get(i);
                for (EObject eRootObject : inputResource.getContents()) {
                    this.rootObjects.add(eRootObject);
                    EClassAnalysis eClassAnalysis = this.getEClassAnalysis(eRootObject);
                    eClassAnalysis.traverseChild(eRootObject);
                }
                ++i;
            }
        }
        if (this.inputObjects != null) {
            for (EObject eRootObject : this.inputObjects) {
                this.rootObjects.add(eRootObject);
                EClassAnalysis eClassAnalysis = this.getEClassAnalysis(eRootObject);
                eClassAnalysis.traverseChild(eRootObject);
            }
        }
        if (this.extentClassIndex >= 0) {
            this.addExtent();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void analyzeOutputResources() {
        if (this.outputResources != null) {
            @NonNull EList contents = this.outputResources.get(0).getContents();
            contents.clear();
            contents.addAll(this.getRootEObjects());
        }
    }

    protected @Nullable List<@NonNull Resource> basicGetInputResources() {
        return this.inputResources;
    }

    public void dispose() {
        if (this.potentialOrphanObjects != null) {
            this.potentialOrphanObjects.clear();
        }
        this.inputResources = null;
    }

    @Deprecated
    public @NonNull Collection<@NonNull EObject> getAllObjects() {
        return this.potentialOrphanObjects != null ? this.potentialOrphanObjects : Collections.emptyList();
    }

    @NonNull Set<@NonNull Integer> getClassIndexes(@NonNull EClass eClass) {
        Set<Integer> classIndexes;
        ClassId classId = IdManager.getClassId((EClass)eClass);
        Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes2 = this.classId2classIndexes;
        if (classId2classIndexes2 == null) {
            classId2classIndexes2 = this.classId2classIndexes = new HashMap<ClassId, Set<Integer>>();
        }
        if ((classIndexes = classId2classIndexes2.get(classId)) == null) {
            classIndexes = new HashSet<Integer>();
            for (EClass eSuperClass : ClassUtil.nullFree((EList)eClass.getESuperTypes())) {
                Set<@NonNull Integer> partialResult = this.getClassIndexes(eSuperClass);
                classIndexes.addAll(partialResult);
            }
            classId2classIndexes2.put(classId, classIndexes);
        }
        return classIndexes;
    }

    @Override
    public @NonNull Connection getConnection(int classIndex) {
        assert (this.classIndex2connection != null);
        return this.classIndex2connection[classIndex];
    }

    protected @NonNull EClassAnalysis getEClassAnalysis(@NonNull EObject eObject) {
        EClassAnalysis eClassAnalysisListHead;
        int ECLASS_IDENTITIES = 256;
        int ECLASS_IDENTITY_MASK = 255;
        @Nullable EClassAnalysis[] eClassAnalysisListHeads2 = this.eClassAnalysisListHeads;
        if (eClassAnalysisListHeads2 == null) {
            this.eClassAnalysisListHeads = eClassAnalysisListHeads2 = new EClassAnalysis[256];
            int i = 0;
            while (i < 256) {
                eClassAnalysisListHeads2[i] = null;
                ++i;
            }
        }
        EClass eClass = eObject.eClass();
        assert (eClass != null);
        int hashCode = System.identityHashCode(eClass) >> 8 & 0xFF;
        EClassAnalysis eClassAnalysis = eClassAnalysisListHead = eClassAnalysisListHeads2[hashCode];
        EClassAnalysis prevEClassAnalysis = null;
        while (eClassAnalysis != null) {
            if (eClassAnalysis.getEClass() == eClass) {
                if (prevEClassAnalysis != null && prevEClassAnalysis != eClassAnalysisListHead) {
                    assert (eClassAnalysisListHead != null);
                    assert (prevEClassAnalysis.nextEClassAnalysis == eClassAnalysis);
                    prevEClassAnalysis.nextEClassAnalysis = eClassAnalysis.nextEClassAnalysis;
                    eClassAnalysis.nextEClassAnalysis = eClassAnalysisListHead;
                    eClassAnalysisListHeads2[hashCode] = eClassAnalysis;
                }
                return eClassAnalysis;
            }
            prevEClassAnalysis = eClassAnalysis;
            eClassAnalysis = eClassAnalysis.nextEClassAnalysis;
        }
        eClassAnalysisListHeads2[hashCode] = eClassAnalysis = new EClassAnalysis(this, eClass, eClassAnalysisListHead);
        return eClassAnalysis;
    }

    protected abstract @Nullable Iterable<@NonNull EObject> getExtentElements(@NonNull EObject var1);

    @Override
    public @NonNull ModelsManager getModelsManager() {
        return this.modelsManager;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull Iterable<@NonNull Object> getObjectsOfKind(@NonNull Class type) {
        Integer classIndex;
        assert (this.classIndex2connection != null);
        TypeId classId = type.getTypeId();
        assert (classId != null);
        if (this.classId2classIndex != null && (classIndex = this.classId2classIndex.get(classId)) != null) {
            Connection connection = this.classIndex2connection[classIndex];
            assert (connection != null);
            return connection.typedIterable(Object.class);
        }
        return EMPTY_EOBJECT_LIST;
    }

    @Deprecated
    public @NonNull Collection<@NonNull Object> getObjectsOfType(@NonNull Class type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Collection<@NonNull EObject> getRootEObjects() {
        boolean hasExtent = false;
        ArrayList<@NonNull EObject> rootEObjects = new ArrayList<EObject>();
        Collection<@NonNull EObject> rootEObjects2 = this.getRootEObjects2();
        for (EObject rootObject : rootEObjects2) {
            Iterable<@NonNull EObject> extentElements = this.getExtentElements(rootObject);
            if (extentElements == null) continue;
            hasExtent = true;
            for (EObject object : extentElements) {
                rootEObjects.add(object);
            }
        }
        if (!hasExtent) {
            for (EObject rootObject : rootEObjects2) {
                rootEObjects.add(rootObject);
            }
        }
        return rootEObjects;
    }

    protected @NonNull Collection<@NonNull EObject> getRootEObjects2() {
        if (this.rootObjects.size() > 0) {
            return this.rootObjects;
        }
        ArrayList<@NonNull EObject> rootObjects2 = new ArrayList<EObject>();
        if (this.potentialOrphanObjects != null) {
            for (EObject eObject : this.potentialOrphanObjects) {
                if (eObject.eContainer() != null) continue;
                rootObjects2.add(eObject);
            }
        }
        if (AbstractTransformer.CONTAINMENTS.isActive()) {
            AbstractTransformer.CONTAINMENTS.println(String.valueOf(this.name) + " " + this.isContainedCount + "/" + (this.isContainedCount + this.isNotContainedCount));
        }
        return rootObjects2;
    }

    @Override
    public @NonNull TypedModelInstance initClassIds(@NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        this.classIndex2classId = classIndex2classId;
        assert (classIndex2allClassIndexes != null);
        int classIds = classIndex2classId.length;
        this.classId2classIndex = new HashMap<ClassId, Integer>(classIds);
        HashMap<@NonNull ClassId, @NonNull Integer> classId2classIndex = this.classId2classIndex;
        this.classId2classIndexes = new HashMap<ClassId, Set<Integer>>(classIds);
        HashMap<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes = this.classId2classIndexes;
        int classIndex = 0;
        while (classIndex < classIds) {
            ClassId classId = classIndex2classId[classIndex];
            classId2classIndex.put(classId, classIndex);
            HashSet<@NonNull Integer> superClassIndexes = new HashSet<Integer>();
            int[] nArray = classIndex2allClassIndexes[classIndex];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int allClassIndex = nArray[n2];
                superClassIndexes.add(allClassIndex);
                ++n2;
            }
            classId2classIndexes.put(classId, superClassIndexes);
            ++classIndex;
        }
        return this;
    }

    @Override
    public void initConnections(@NonNull Interval rootInterval, @NonNull ModeFactory modeFactory) {
        @NonNull ClassId[] classIndex2classId2 = this.classIndex2classId;
        if (classIndex2classId2 != null) {
            this.classIndex2connection = new Connection[classIndex2classId2.length];
            @NonNull Connection[] classIndex2connection = this.classIndex2connection;
            int classIndex = 0;
            ClassId[] classIdArray = classIndex2classId2;
            int n = classIndex2classId2.length;
            int n2 = 0;
            while (n2 < n) {
                ClassId classId = classIdArray[n2];
                String connectionName = String.valueOf(this.name) + "!" + classId.getName();
                classIndex2connection[classIndex] = rootInterval.createConnection(connectionName, (TypeId)classId, false, modeFactory);
                ++classIndex;
                ++n2;
            }
        }
    }

    @Override
    public <K, V> void initExtent(int extentClassIndex, @Nullable Map<K, V> extentOpposites) {
        this.extentClassIndex = extentClassIndex;
        this.extentOpposites = extentOpposites;
    }

    public void remove(@NonNull EObject eObject) {
        if (this.potentialOrphanObjects != null) {
            this.potentialOrphanObjects.remove(eObject);
        }
    }

    @Override
    @Deprecated
    public void removeInputResources() {
        if (this.inputResources != null) {
            this.inputResources.clear();
        }
        this.rootObjects.clear();
        if (this.classIndex2connection != null) {
            Connection[] connectionArray = this.classIndex2connection;
            int n = this.classIndex2connection.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull Connection connection = connectionArray[n2];
                connection.clear();
                ++n2;
            }
        }
    }

    @Override
    @Deprecated
    public void removeOutputResources() {
        this.isContainedCount = 0;
        this.isNotContainedCount = 0;
        if (this.outputResources != null) {
            this.outputResources.clear();
        }
        if (this.potentialOrphanObjects != null) {
            this.potentialOrphanObjects.clear();
        }
        this.rootObjects.clear();
    }

    @Override
    public void saveResources(@Nullable Map<?, ?> saveOptions) throws IOException {
        List<@NonNull Resource> outputResources2 = this.outputResources;
        if (outputResources2 != null) {
            if (saveOptions == null) {
                Map castSaveOptions = saveOptions = XMIUtil.createSaveOptions();
                castSaveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
            }
            for (Resource outputResource : outputResources2) {
                outputResource.save(saveOptions);
            }
        }
    }

    public void setTrackAdditions(@Nullable Boolean trackAdditions) {
        this.trackAdditions = trackAdditions;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.rootObjects.size() + " (" + (this.potentialOrphanObjects != null ? this.potentialOrphanObjects.size() : 0) + ")";
    }

    public <T> Iterable<T> typedIterable(java.lang.Class<T> javaClass, @NonNull Class pivotType) {
        Integer classIndex;
        assert (this.classIndex2connection != null);
        TypeId typeId = pivotType.getTypeId();
        Integer n = classIndex = this.classId2classIndex != null ? this.classId2classIndex.get(typeId) : null;
        if (classIndex != null) {
            Connection connection = this.classIndex2connection[classIndex];
            return connection.typedIterable(javaClass);
        }
        return null;
    }
}

