/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.examples.qvtrelation.modelmorf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.qvtd.examples.qvtrelation.modelmorf.MetamodelEntry;
import org.eclipse.qvtd.examples.qvtrelation.modelmorf.ModelEntry;

public class ModelMorfComponent
implements IWorkflowComponent {
    private static final String METAMODEL_ALIAS = "-m";
    private static final String METAMODEL_FILE = "-mf";
    private static final String METAMODEL_REFERENCE = "-mi";
    private static final String QVT_SPECIFICATION_FILE = "-c";
    private static final String IMPORTED_QVT_FILE_DIR = "-qp";
    private static final String MODEL_VARIABLE = "-u";
    private static final String MODEL_FILE = "-f";
    private static final String MODEL_REFERENCE = "-ui";
    private static final String MODEL_DELTA = "-df";
    private static final String TRANSFORMATION_NAME = "-t";
    private static final String TOP_RELATION_NAME = "-r";
    private static final String DIRECTION_DOMAIN = "-d";
    private static final String DOMAIN_QUALIFIER = "-q";
    private static final String TRACE_OUTPUT_FILE = "-tox";
    private static final String TRACE_INPUT_FILE = "-tix";
    private static final String INCREMENTAL = "-it";
    private String java15Path;
    private String modelMorfPath;
    private String javaCommand = "java";
    private List<MetamodelEntry> metamodels = new ArrayList<MetamodelEntry>();
    private List<String> importedQvtFileDir;
    private List<ModelEntry> models = new ArrayList<ModelEntry>();
    private String qvtSpecificationFile;
    private String transformationName;
    private String topRelationName;
    private String directionDomain;
    private String domainQualifier;
    private String traceOutputFile;
    private String traceInputFile;
    private boolean incremental;

    public ModelMorfComponent() {
        this.importedQvtFileDir = new ArrayList<String>();
    }

    public void preInvoke() {
    }

    public void invoke(IWorkflowContext ctx) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder argBuilder = new StringBuilder();
        argBuilder.append(this.java15Path);
        if (!this.java15Path.endsWith("\\")) {
            argBuilder.append("\\");
        }
        argBuilder.append(this.javaCommand);
        arguments.add(argBuilder.toString());
        argBuilder.setLength(0);
        arguments.add("-jar");
        argBuilder.append(this.modelMorfPath);
        if (!this.modelMorfPath.endsWith("\\")) {
            argBuilder.append("\\");
        }
        argBuilder.append("qvt.jar");
        arguments.add(argBuilder.toString());
        argBuilder.setLength(0);
        arguments.add("-p");
        arguments.add(this.modelMorfPath);
        for (MetamodelEntry entry : this.metamodels) {
            arguments.add(METAMODEL_ALIAS);
            arguments.add(entry.getAlias());
            if (entry.isRelative()) {
                arguments.add(METAMODEL_REFERENCE);
                arguments.add(entry.getReference());
                continue;
            }
            arguments.add(METAMODEL_FILE);
            arguments.add(entry.getFile());
        }
        arguments.add(QVT_SPECIFICATION_FILE);
        arguments.add(this.getQvtSpecificationFile());
        if (!this.importedQvtFileDir.isEmpty()) {
            arguments.add(IMPORTED_QVT_FILE_DIR);
            Iterator<String> lIt = this.importedQvtFileDir.iterator();
            while (lIt.hasNext()) {
                argBuilder.append(lIt.next());
                if (!lIt.hasNext()) continue;
                argBuilder.append(";");
            }
            arguments.add(argBuilder.toString());
            argBuilder.setLength(0);
        }
        for (ModelEntry entry : this.models) {
            arguments.add(MODEL_VARIABLE);
            arguments.add(entry.getVariable());
            if (entry.isBound()) {
                arguments.add(MODEL_REFERENCE);
                arguments.add(entry.getVariableRef());
            } else {
                arguments.add(MODEL_FILE);
                arguments.add(entry.getFile());
            }
            if (!entry.hasDelta()) continue;
            arguments.add(MODEL_DELTA);
            arguments.add(entry.getDeltaFile());
        }
        arguments.add(TRANSFORMATION_NAME);
        arguments.add(this.getTransformationName());
        if (this.getTopRelationName() != null) {
            arguments.add(TOP_RELATION_NAME);
            arguments.add(this.getTransformationName());
        }
        arguments.add(DIRECTION_DOMAIN);
        arguments.add(this.getDirectionDomain());
        arguments.add(DOMAIN_QUALIFIER);
        arguments.add(this.getDomainQualifier());
        if (this.getTraceOutputFile() != null) {
            arguments.add(TRACE_OUTPUT_FILE);
            arguments.add(this.getTraceOutputFile());
        }
        if (this.getTraceInputFile() != null) {
            arguments.add(TRACE_INPUT_FILE);
            arguments.add(this.getTraceOutputFile());
        }
        if (this.isIncremental()) {
            arguments.add(INCREMENTAL);
        }
        ProcessBuilder probuilder = new ProcessBuilder(arguments);
        File dir = new File("C:/git/org.eclipse.qvtd/examples/org.eclipse.qvtd.examples.qvtrelation.modelmorf/qvtrsrc/org/eclipse/qvtd/examples/qvtrelation/modelmorf/hstmtostm");
        probuilder.directory(dir);
        System.out.println(probuilder.directory());
        probuilder.redirectErrorStream(true);
        try {
            String line;
            Process process = probuilder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            System.out.printf("Running ModelMorf with the given parameters.", new Object[0]);
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void postInvoke() {
    }

    public String getJava15Path() {
        return this.java15Path;
    }

    public void setJava15Path(String java15Path) {
        this.java15Path = java15Path;
    }

    public String getModelMorfPath() {
        return this.modelMorfPath;
    }

    public void setModelMorfPath(String modelMorfPath) {
        this.modelMorfPath = modelMorfPath;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public void setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
    }

    public String getQvtSpecificationFile() {
        return this.qvtSpecificationFile;
    }

    public void setQvtSpecificationFile(String qvtSpecificationFile) {
        this.qvtSpecificationFile = qvtSpecificationFile;
    }

    public String getTransformationName() {
        return this.transformationName;
    }

    public void setTransformationName(String transformationName) {
        this.transformationName = transformationName;
    }

    public String getTopRelationName() {
        return this.topRelationName;
    }

    public void setTopRelationName(String topRelationName) {
        this.topRelationName = topRelationName;
    }

    public String getDirectionDomain() {
        return this.directionDomain;
    }

    public void setDirectionDomain(String directionDomain) {
        this.directionDomain = directionDomain;
    }

    public String getDomainQualifier() {
        return this.domainQualifier;
    }

    public void setDomainQualifier(String domainQualifier) {
        this.domainQualifier = domainQualifier;
    }

    public String getTraceOutputFile() {
        return this.traceOutputFile;
    }

    public void setTraceOutputFile(String traceOutputFile) {
        this.traceOutputFile = traceOutputFile;
    }

    public String getTraceInputFile() {
        return this.traceInputFile;
    }

    public void setTraceInputFile(String traceInputFile) {
        this.traceInputFile = traceInputFile;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void addMetamodel(MetamodelEntry metamodel) {
        this.metamodels.add(metamodel);
    }

    public void addImportedQvtFileDir(String fileDir) {
        this.importedQvtFileDir.add(fileDir);
    }

    public void addModel(ModelEntry model) {
        this.models.add(model);
    }
}

